/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.mobile;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.domain.ActivityTag;
import com.wego168.activity.enums.ActivityOderTypeEnum;
import com.wego168.activity.enums.ActivityStatusEnum;
import com.wego168.activity.model.response.DistributerActivityWebPageResponse;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityPointService;
import com.wego168.activity.service.ActivityPointSettingService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivityTagService;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Category;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.Visitable;
import com.wego168.base.domain.VisitableBean;
import com.wego168.base.enums.LevelTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.VisitSourceTypeEnum;
import com.wego168.base.scheduler.ExperienceAsync;
import com.wego168.base.service.CategoryService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.SignService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ActivityController
extends CrudController<Activity> {
    private final Logger logger = LoggerFactory.getLogger(ActivityController.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityTagService activityTagService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private SignService signService;
    @Autowired
    private ExperienceAsync experienceAsync;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ActivityPointSettingService activityPointSettingService;
    @Autowired
    private ActivityPointService activityPointService;
    @Autowired
    private ConfigService configService;

    public CrudService<Activity> getService() {
        return this.activityService;
    }

    @GetMapping(value={"/api/v1/activity/distributer-page"})
    public RestResponse distributerActivityPage(String title, String orderByType, HttpServletRequest request) {
        String appId = this.getAppId();
        String orderBy = "af.distributer_commission DESC";
        Page page = this.buildPage(request);
        if (StringUtil.isNotBlank((String)orderByType)) {
            if (StringUtil.equals((String)orderByType, (String)"highCommissionFirst")) {
                orderBy = "af.distributer_commission DESC";
            } else if (StringUtil.equals((String)orderByType, (String)"newFirst")) {
                orderBy = "a.create_time DESC";
            } else if (StringUtil.equals((String)orderByType, (String)"default")) {
                orderBy = "a.seq_num DESC, a.create_time DESC";
            }
        } else {
            Config config = this.configService.selectByKey("activity_order_type", appId);
            if (config != null) {
                String alias = "a.";
                orderBy = this.determineOrderBy(config, alias);
            }
        }
        List<DistributerActivityWebPageResponse> list = this.activityService.selectDistributerActivityPage(title, orderBy, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/activity/sharer-page"})
    public RestResponse sharerActivityPage(String title, String orderByType, HttpServletRequest request) {
        String appId = this.getAppId();
        String orderBy = "af.sharer_commission DESC";
        Page page = this.buildPage(request);
        if (StringUtil.isNotBlank((String)orderByType)) {
            if (StringUtil.equals((String)orderByType, (String)"highCommissionFirst")) {
                orderBy = "af.sharer_commission DESC";
            } else if (StringUtil.equals((String)orderByType, (String)"newFirst")) {
                orderBy = "a.create_time DESC";
            } else if (StringUtil.equals((String)orderByType, (String)"default")) {
                orderBy = "a.seq_num DESC, a.create_time DESC";
            }
        } else {
            Config config = this.configService.selectByKey("activity_order_type", appId);
            if (config != null) {
                String alias = "a.";
                orderBy = this.determineOrderBy(config, alias);
            }
        }
        List<DistributerActivityWebPageResponse> list = this.activityService.selectSharerActivityPage(title, orderBy, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u8fd1\u671f\u6d3b\u52a8\u5217\u8868")
    @GetMapping(value={"/api/v1/activity/recentPage"})
    public RestResponse recentPage(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Activity> list = this.activityService.getList(page);
        if (list != null && list.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (Activity activity : list) {
                activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
                idList.add(activity.getId());
            }
            List<ActivityTag> tags = this.activityTagService.selectByActivityIds(idList);
            HashMap tagMap = new HashMap();
            for (ActivityTag at : tags) {
                String activityId = at.getActivityId();
                if (!tagMap.containsKey(activityId)) {
                    tagMap.put(activityId, new LinkedList());
                }
                List tempList = (List)tagMap.get(activityId);
                tempList.add(at);
            }
            List<ActivityFee> fees = this.activityFeeService.selectByActivityIds(idList);
            HashMap<String, ActivityFee> feeMap = new HashMap<String, ActivityFee>();
            for (ActivityFee af : fees) {
                feeMap.put(af.getActivityId(), af);
            }
            for (Activity activity : list) {
                activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
                activity.setActivityTagList((List)tagMap.get(activity.getId()));
                activity.setActivityFee((ActivityFee)((Object)feeMap.get(activity.getId())));
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6240\u6709\u6d3b\u52a8\u5217\u8868")
    @GetMapping(value={"/api/v1/activity/page"})
    public RestResponse page(HttpServletRequest request) {
        List list;
        Config config;
        Page page = this.buildPage(request);
        int type = RequestUtil.getIntegerParam((HttpServletRequest)request, (String)"type", (Integer)1);
        page.eq("appId").eq("categoryId").eq("type", (Object)type).eq("isRelease", (Object)true).like("title");
        String startTime = (String)page.get((Object)"startTime");
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            String min = "";
            String max = "";
            if (startTime.length() == 7) {
                min = startTime + "-01 00:00:00.000";
                max = startTime + "-31 23:59:59.999";
                page.between("startTime", (Object)min, (Object)max);
            } else if (startTime.length() == 10) {
                min = startTime + " 00:00:00.000";
                max = startTime + " 23:59:59.999";
                page.between("startTime", (Object)min, (Object)max);
            }
        }
        if (null != (config = this.configService.selectByKey("activity_order_type", this.getAppId()))) {
            this.setSort(page, config);
        }
        if ((list = this.activityService.selectPage(page)) != null && list.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (Activity activity : list) {
                idList.add(activity.getId());
            }
            List<ActivityTag> tags = this.activityTagService.selectByActivityIds(idList);
            HashMap tagMap = new HashMap();
            for (ActivityTag at : tags) {
                String activityId = at.getActivityId();
                if (!tagMap.containsKey(activityId)) {
                    tagMap.put(activityId, new LinkedList());
                }
                List tempList = (List)tagMap.get(activityId);
                tempList.add(at);
            }
            List<ActivityFee> fees = this.activityFeeService.selectByActivityIds(idList);
            HashMap<String, ActivityFee> feeMap = new HashMap<String, ActivityFee>();
            for (ActivityFee af : fees) {
                feeMap.put(af.getActivityId(), af);
            }
            for (Activity activity : list) {
                activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
                activity.setActivityTagList((List)tagMap.get(activity.getId()));
                activity.setActivityFee((ActivityFee)((Object)feeMap.get(activity.getId())));
                activity.setStartTimeStr(DateTimeUtil.convertFormat((Date)activity.getStartTime()));
                Integer signNum = this.activityService.getSettingSignNum(activity.getId());
                if (signNum != null) {
                    activity.setSignNum(signNum);
                }
                if (!StringUtil.isNotBlank((String)activity.getCategoryId())) continue;
                activity.setCategoryStr(((Category)this.categoryService.selectById((Object)activity.getCategoryId())).getName());
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6211\u62a5\u540d\u7684\u6d3b\u52a8")
    @GetMapping(value={"/api/v1/activity/signActivityPage"})
    public RestResponse signActivityPage(Boolean doNotShowPreview, HttpServletRequest request) {
        Page page = this.buildPage(request);
        int type = RequestUtil.getIntegerParam((HttpServletRequest)request, (String)"type", (Integer)1);
        page.put((Object)"type", (Object)type);
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        page.put((Object)"memberId", (Object)memberId);
        doNotShowPreview = doNotShowPreview == null ? false : doNotShowPreview;
        page.put((Object)"doNotShowPreview", (Object)doNotShowPreview);
        List<Activity> list = this.activityService.signActivityPage(page);
        if (list != null && list.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (Activity activity : list) {
                idList.add(activity.getId());
            }
            List<ActivityTag> tags = this.activityTagService.selectByActivityIds(idList);
            HashMap tagMap = new HashMap();
            for (ActivityTag at : tags) {
                String activityId = at.getActivityId();
                if (!tagMap.containsKey(activityId)) {
                    tagMap.put(activityId, new LinkedList());
                }
                List tempList = (List)tagMap.get(activityId);
                tempList.add(at);
            }
            List<ActivityFee> fees = this.activityFeeService.selectByActivityIds(idList);
            HashMap<String, ActivityFee> feeMap = new HashMap<String, ActivityFee>();
            for (ActivityFee af : fees) {
                feeMap.put(af.getActivityId(), af);
            }
            for (Activity activity : list) {
                activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
                activity.setActivityTagList((List)tagMap.get(activity.getId()));
                activity.setActivityFee((ActivityFee)((Object)feeMap.get(activity.getId())));
                activity.setStartTimeStr(DateTimeUtil.convertFormat((Date)activity.getStartTime()));
                Integer signNum = this.activityService.getSettingSignNum(activity.getId());
                if (signNum == null) continue;
                activity.setSignNum(signNum);
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6d3b\u52a8\u8be6\u60c5")
    @GetMapping(value={"/api/v1/activity/get"})
    public RestResponse get(HttpServletRequest request, String id, @RequestParam(name="shareMemberId", required=false) String shareMemberId) {
        Activity activity = this.activityService.getMobile(id);
        activity.setStartTimeStr(DateTimeUtil.convertFormat((Date)activity.getStartTime()));
        activity.setEndTimeStr(DateTimeUtil.convertFormat((Date)activity.getEndTime()));
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        Sign sign = (Sign)this.signService.select(JpaCriteria.builder().eq("sourceId", (Object)activity.getId()).eq("memberId", (Object)memberId).ne("status", (Object)SignStatusEnum.CANCEL.getIndex()));
        activity.setSign(sign);
        if (StringUtils.isNotBlank((CharSequence)shareMemberId)) {
            this.experienceAsync.addExperience(LevelTypeEnum.INFLUENCE.getIndex().intValue(), "activity_share_read", shareMemberId, memberId + "_" + id, activity.getAppId());
        }
        request.setAttribute("VISITABLE_TARGET", (Object)new VisitableBean((Visitable)activity, VisitSourceTypeEnum.ACTIVITY.value(), memberId));
        return RestResponse.success((Object)((Object)activity));
    }

    @PostMapping(value={"/api/v1/activity/share"})
    public RestResponse share(@NotBlankAndLength(message="\u6d3b\u52a8id\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String id, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        if (StringUtil.isBlank((String)memberId)) {
            return RestResponse.success((Object)0, (String)"\u672a\u5206\u4eab\u6210\u529f\uff0c\u4f1a\u5458\u672a\u767b\u5f55");
        }
        Activity activity = (Activity)((Object)this.activityService.selectById(id));
        if (activity == null) {
            return RestResponse.success((Object)0, (String)"\u672a\u5206\u4eab\u6210\u529f\uff0c\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        ActivityPointSetting activityPoint = this.activityPointSettingService.selectByActivityId(id);
        if (activityPoint == null || IntegerUtil.equals((Integer)activityPoint.getSharePoint(), (Integer)0)) {
            return RestResponse.success((Object)0, (String)"\u672a\u5206\u4eab\u6210\u529f\uff0c\u8be5\u6d3b\u52a8\u672a\u5f00\u542f\u5206\u4eab\u914d\u7f6e");
        }
        int maxSharePointPerDay = activityPoint.getMaxSharePointPerDay();
        int sharePoint = activityPoint.getSharePoint();
        int todaySharePoint = this.activityPointService.sumTodayActivitySharePoint(id, memberId);
        if (maxSharePointPerDay >= 0 && todaySharePoint >= maxSharePointPerDay) {
            return RestResponse.success((Object)0, (String)"\u4eca\u5929\u5df2\u4e0d\u80fd\u7ee7\u7eed\u518d\u83b7\u5f97\u5206\u4eab\u79ef\u5206");
        }
        int point = maxSharePointPerDay - todaySharePoint;
        if (point > sharePoint) {
            point = sharePoint;
        }
        int givePoints = this.activityPointService.giveShareActivityPoint(point, memberId, activity);
        return RestResponse.success((Object)givePoints, (String)"\u5206\u4eab\u6210\u529f");
    }

    @GetMapping(value={"/api/v1/activity/getIds"})
    public RestResponse getIds(String ids) {
        List list;
        Config config;
        Object[] activityIds = ids.split(",");
        Page page = new Page();
        page.in("id", activityIds);
        String startTime = (String)page.get((Object)"startTime");
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            String min = "";
            String max = "";
            if (startTime.length() == 7) {
                min = startTime + "-01 00:00:00.000";
                max = startTime + "-31 23:59:59.999";
                page.between("startTime", (Object)min, (Object)max);
            } else if (startTime.length() == 10) {
                min = startTime + " 00:00:00.000";
                max = startTime + " 23:59:59.999";
                page.between("startTime", (Object)min, (Object)max);
            }
        }
        if (null != (config = this.configService.selectByKey("activity_order_type", this.getAppId()))) {
            this.setSort(page, config);
        }
        if ((list = this.activityService.selectPage(page)) != null && list.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (Activity activity : list) {
                idList.add(activity.getId());
            }
            List<ActivityTag> tags = this.activityTagService.selectByActivityIds(idList);
            HashMap tagMap = new HashMap();
            for (ActivityTag at : tags) {
                String activityId = at.getActivityId();
                if (!tagMap.containsKey(activityId)) {
                    tagMap.put(activityId, new LinkedList());
                }
                List tempList = (List)tagMap.get(activityId);
                tempList.add(at);
            }
            List<ActivityFee> fees = this.activityFeeService.selectByActivityIds(idList);
            HashMap<String, ActivityFee> feeMap = new HashMap<String, ActivityFee>();
            for (ActivityFee af : fees) {
                feeMap.put(af.getActivityId(), af);
            }
            for (Activity activity : list) {
                activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
                activity.setActivityTagList((List)tagMap.get(activity.getId()));
                activity.setActivityFee((ActivityFee)((Object)feeMap.get(activity.getId())));
                activity.setStartTimeStr(DateTimeUtil.convertFormat((Date)activity.getStartTime()));
                Integer signNum = this.activityService.getSettingSignNum(activity.getId());
                if (signNum != null) {
                    activity.setSignNum(signNum);
                }
                if (!StringUtil.isNotBlank((String)activity.getCategoryId())) continue;
                activity.setCategoryStr(((Category)this.categoryService.selectById((Object)activity.getCategoryId())).getName());
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    private void setSort(Page page, Config config) {
        String alias = "";
        page.orderBy(this.determineOrderBy(config, alias));
    }

    private String determineOrderBy(Config config, String alias) {
        if (StringUtil.isBlank((String)alias)) {
            alias = "";
        }
        StringBuffer sqlBuffer = new StringBuffer();
        int value = Integer.parseInt(config.getValue());
        if (IntegerUtil.equals((Integer)value, (Integer)ActivityOderTypeEnum.SORT.getIndex())) {
            sqlBuffer.append(alias).append("seq_num DESC, ").append(alias).append("create_time DESC");
        } else if (IntegerUtil.equals((Integer)value, (Integer)ActivityOderTypeEnum.DEFAULT.getIndex())) {
            sqlBuffer.append(alias).append("status DESC, ").append(alias).append("create_time DESC");
        } else if (IntegerUtil.equals((Integer)value, (Integer)ActivityOderTypeEnum.CREATE_TIME.getIndex())) {
            sqlBuffer.append(alias).append("create_time DESC");
        } else {
            sqlBuffer.append(alias).append("create_time DESC");
        }
        return sqlBuffer.toString();
    }
}

