/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.provider;

import com.alibaba.fastjson.JSONObject;
import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.enums.ActivitySignSettingScopeEnum;
import com.wego168.activity.model.response.SignResponse;
import com.wego168.activity.response.ActivityResponseParam;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityPointSettingService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.CheckinTime;
import com.wego168.base.domain.LevelExperience;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignParam;
import com.wego168.base.domain.WechatQrcode;
import com.wego168.base.enums.LevelTypeEnum;
import com.wego168.base.enums.OrderTypeEnum;
import com.wego168.base.enums.QrCodeTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.scheduler.ExperienceAsync;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.base.service.LevelExperienceService;
import com.wego168.base.service.SignService;
import com.wego168.base.service.WechatQrcodeService;
import com.wego168.channel.domain.Channel;
import com.wego168.channel.domain.ChannelCode;
import com.wego168.channel.service.ChannelCodeService;
import com.wego168.channel.service.ChannelService;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.enums.DistributerStatusEnum;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.domain.CosAccess;
import com.wego168.member.domain.Coupon;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.CouponService;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.LockCallBack;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.share.domain.Sharer;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.EnvironmentUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.HibernateValidators;
import com.wego168.wechat.api.IWechatAccessToken;
import com.wego168.wechat.api.IWechatFans;
import com.wego168.wechat.api.IWechatQrcode;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayWayEnum;
import com.wego168.wxpay.service.PayService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ActivityProvider {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private SignService signService;
    @Autowired
    private IWechatAccessToken wechatAccessTokenHelper;
    @Autowired
    private WechatQrcodeService wechatQrcodeService;
    @Autowired
    private IWechatQrcode wechatQrcodeHelper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private ActivityPointSettingService activityScoreService;
    @Autowired
    private ActivitySignService activitySignService;
    @Autowired
    private IWechatFans wechatFansHelper;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ChannelCodeService channelCodeService;
    @Autowired
    private DistributerService distributerService;
    @Autowired
    private ExperienceAsync experienceAsync;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private CheckinSettingService checkinSettingService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private PayService payService;
    @Autowired
    private Environment env;
    @Autowired
    private LevelExperienceService levelExperienceService;
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private MemberAccountService memberAccountService;
    private static final Logger logger = LoggerFactory.getLogger(ActivityProvider.class);

    @Transactional
    public String insert(Activity activity) {
        List checkinTimeList;
        CosAccess cosAccess = EnvironmentUtil.createCosAccess((Environment)this.env);
        Shift.throwsIfNull((Object)cosAccess, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        if (activity.getIsEnableFee().booleanValue()) {
            HibernateValidators.throwsIfInvalid((Object)((Object)activity.getActivityFee()), (Class[])new Class[0]);
        }
        HibernateValidators.throwsIfInvalid((Object)((Object)activity.getActivitySignSetting()), (Class[])new Class[0]);
        activity.setId(GuidGenerator.generate());
        CheckinSetting activityCheckinSetting = activity.getActivityCheckinSetting();
        activityCheckinSetting.setSourceId(activity.getId());
        activityCheckinSetting.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        if (activityCheckinSetting.getIsCheckinCode() == null) {
            activityCheckinSetting.setIsCheckinCode(Boolean.valueOf(false));
        }
        ArrayList<CheckinSetting> checkinSettingList = new ArrayList<CheckinSetting>();
        ArrayList<WechatQrcode> wechatQrcodeList = new ArrayList<WechatQrcode>();
        if (activity.getIsEnableCheckin().booleanValue() && activityCheckinSetting != null && (checkinTimeList = activityCheckinSetting.getCheckinTimeList()) != null && checkinTimeList.size() > 0) {
            String appId = this.wechatAccessTokenHelper.getAppId();
            logger.error("appid" + appId);
            String accessToken = this.wechatAccessTokenHelper.getToken(appId, false);
            int maxId = this.wechatQrcodeService.maxScenceId();
            for (CheckinTime checkinTime : checkinTimeList) {
                this.activityService.validCheckinTime(checkinTime);
                CheckinSetting checkinSetting = new CheckinSetting();
                BeanUtils.copyProperties((Object)activityCheckinSetting, (Object)checkinSetting);
                checkinSetting.setId(GuidGenerator.generate());
                checkinSetting.setCheckinEndTime(checkinTime.getCheckinEndTime());
                checkinSetting.setCheckinStartTime(checkinTime.getCheckinStartTime());
                checkinSetting.setCheckinLateTime(checkinTime.getCheckinLateTime());
                String ticket = this.wechatQrcodeHelper.createQrcodeTicket(Integer.valueOf(2592000), true, Integer.valueOf(++maxId), accessToken);
                File file = this.wechatQrcodeHelper.getQrcodeByTicket(JSONObject.parseObject((String)ticket).getString("ticket"));
                String formattedPath = FileUploadUtil.upload((File)file, (String)(GuidGenerator.generate() + ".png"), (String)"QRCode", (CosAccess)cosAccess);
                WechatQrcode wechatQrcode = new WechatQrcode();
                wechatQrcode.setObjId(checkinSetting.getId());
                wechatQrcode.setObjType(QrCodeTypeEnum.ACTIVITY_CHECKIN.getIndex());
                wechatQrcode.setSceneId(Integer.valueOf(maxId));
                wechatQrcode.setImgUrl(formattedPath);
                wechatQrcodeList.add(wechatQrcode);
                checkinSetting.setCheckinQrcodeUrl(formattedPath);
                checkinSettingList.add(checkinSetting);
            }
        }
        String id = this.activityService.insertActivity(activity, wechatQrcodeList, checkinSettingList);
        return id;
    }

    @Transactional
    public String update(Activity activity) {
        CosAccess cosAccess = EnvironmentUtil.createCosAccess((Environment)this.env);
        Shift.throwsIfNull((Object)cosAccess, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        CheckinSetting activityCheckinSetting = activity.getActivityCheckinSetting();
        if (activityCheckinSetting.getIsCheckinCode() == null) {
            activityCheckinSetting.setIsCheckinCode(Boolean.valueOf(false));
        }
        HashMap<String, WechatQrcode> qrcodeMap = new HashMap<String, WechatQrcode>();
        LinkedList<CheckinSetting> checkinSettingList = new LinkedList<CheckinSetting>();
        if (activity.getIsEnableCheckin().booleanValue() && activityCheckinSetting != null) {
            String appId = this.wechatAccessTokenHelper.getAppId();
            String accessToken = this.wechatAccessTokenHelper.getToken(appId, false);
            int maxId = this.wechatQrcodeService.maxScenceId();
            List checkinTimeList = activityCheckinSetting.getCheckinTimeList();
            for (CheckinTime checkinTime : checkinTimeList) {
                this.activityService.validCheckinTime(checkinTime);
                String id = checkinTime.getCheckinSettingId();
                activityCheckinSetting.setId(id);
                CheckinSetting checkinSetting = new CheckinSetting();
                BeanUtils.copyProperties((Object)activityCheckinSetting, (Object)checkinSetting);
                checkinSetting.setSourceId(activity.getId());
                checkinSetting.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
                checkinSetting.setCheckinEndTime(checkinTime.getCheckinEndTime());
                checkinSetting.setCheckinStartTime(checkinTime.getCheckinStartTime());
                checkinSetting.setCheckinLateTime(checkinTime.getCheckinLateTime());
                if (StringUtils.isBlank((CharSequence)id)) {
                    checkinSetting.setId(GuidGenerator.generate());
                    String ticket = this.wechatQrcodeHelper.createQrcodeTicket(Integer.valueOf(2592000), true, Integer.valueOf(++maxId), accessToken);
                    WechatQrcode wechatQrcode = new WechatQrcode();
                    wechatQrcode.setSceneId(Integer.valueOf(maxId));
                    wechatQrcode.setObjId(checkinSetting.getId());
                    wechatQrcode.setObjType(QrCodeTypeEnum.ACTIVITY_CHECKIN.getIndex());
                    JSONObject o = JSONObject.parseObject((String)ticket);
                    if (o.containsKey((Object)"ticket")) {
                        File file = this.wechatQrcodeHelper.getQrcodeByTicket(o.getString("ticket"));
                        String formattedPath = FileUploadUtil.upload((File)file, (String)(GuidGenerator.generate() + ".png"), (String)"QRCode", (CosAccess)cosAccess);
                        wechatQrcode.setImgUrl(formattedPath);
                        checkinSetting.setCheckinQrcodeUrl(formattedPath);
                    }
                    qrcodeMap.put(checkinSetting.getId(), wechatQrcode);
                }
                checkinSettingList.add(checkinSetting);
            }
        }
        String id = this.activityService.updateActivity(activity, qrcodeMap, checkinSettingList);
        return id;
    }

    public String isMobileVerify(SignParam activitySign, String code, HttpServletRequest request) {
        Sign sign = activitySign.getSign();
        Shift.throwsIfBlank((String)sign.getSourceId(), (String)"\u7f3a\u5c11\u53c2\u6570");
        ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)sign.getSourceId())));
        Shift.throwsIfNull((Object)((Object)activitySignSetting), (String)"\u83b7\u53d6\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        Shift.throwsIfBlank((String)memberId, (String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        Member member = this.memberService.selectById(memberId);
        if (activitySignSetting.getIsEnableSMSVerify().booleanValue() && StringUtil.isNotBlank((String)code)) {
            Checker.checkBlank((String)code, (String)"\u9a8c\u8bc1\u7801");
            String key = String.format("activity_sign_%s", member.getMobilePhoneNumber());
            String validateCode = this.simpleRedisTemplate.getString(key);
            Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)validateCode), (String)"\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
            Shift.throwsIfInvalid((!StringUtils.equals((CharSequence)validateCode, (CharSequence)code) ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return null;
        }
        if (activitySignSetting.getIsEnableSMSVerify().booleanValue()) {
            Shift.throwsIfNull((Object)member.getMobilePhoneNumber(), (String)"\u83b7\u53d6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25");
            return member.getMobilePhoneNumber();
        }
        return null;
    }

    public ActivityResponseParam sign(final SignParam activitySign) {
        String shareMemberId;
        final Sign sign = activitySign.getSign();
        String activityId = sign.getSourceId();
        sign.setId(GuidGenerator.generate());
        Shift.throwsIfBlank((String)activityId, (String)"\u7f3a\u5c11\u6d3b\u52a8id");
        final ActivitySignSetting signSetting = this.activitySignSettingService.selectByActivityId(activityId);
        Shift.throwsIfNull((Object)((Object)signSetting), (String)"\u83b7\u53d6\u6d3b\u52a8\u62a5\u540d\u8bbe\u7f6e\u5931\u8d25");
        final Activity activity = this.activityService.get(activityId);
        Shift.throwsIfNull((Object)((Object)activity), (String)"\u83b7\u53d6\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        String appId = activity.getAppId();
        String memberId = "";
        memberId = StringUtil.equals((String)ActivitySignSettingScopeEnum.AUTH.value(), (String)signSetting.getSignScope()) ? SessionUtil.getMemberIdIfNotAuthToThrow() : SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        Shift.throwsIfBlank((String)memberId, (String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        final Member member = this.memberService.selectById(memberId);
        Shift.throwsIfNull((Object)member, (String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        logger.error("\u6d3b\u52a8\u62a5\u540d\u6807\u9898\uff1a{}\uff0cid\uff1a{}", (Object)activity.getTitle(), (Object)activity.getId());
        Date now = new Date();
        String checkinSettingId = sign.getCheckinSettingId();
        boolean airboneCheckin = StringUtil.isNotBlank((String)checkinSettingId);
        if (airboneCheckin) {
            CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
            Shift.throwsIfNull((Object)checkinSetting, (String)"\u7b7e\u5230\u4e0d\u5b58\u5728");
            Shift.throwsIfInvalid((checkinSetting.getIsEnableAirborne() == false ? 1 : 0) != 0, (String)"\u672a\u5f00\u542f\u7a7a\u964d\u5609\u5bbe\u7b7e\u5230");
            Shift.throwsIfInvalid((boolean)now.after(checkinSetting.getCheckinEndTime()), (String)"\u7b7e\u5230\u5df2\u7ed3\u675f");
            Shift.throwsIfInvalid((boolean)now.before(checkinSetting.getCheckinStartTime()), (String)"\u7b7e\u5230\u672a\u5f00\u59cb");
            if (sign.getNum() == null || sign.getNum() == 0) {
                sign.setNum(Integer.valueOf(1));
            }
        } else {
            Shift.throwsIfInvalid((boolean)now.after(signSetting.getSignEndTime()), (String)"\u62a5\u540d\u5df2\u7ed3\u675f");
            Shift.throwsIfInvalid((boolean)now.before(signSetting.getSignStartTime()), (String)"\u62a5\u540d\u672a\u5f00\u59cb");
            Shift.throwsIfInvalid((signSetting.getMaxNum() != 0 && signSetting.getSignNum() + sign.getNum() > signSetting.getMaxNum() ? 1 : 0) != 0, (String)"\u8d85\u8fc7\u6700\u5927\u62a5\u540d\u4eba\u6570");
        }
        if (signSetting.getIsNeedSubscribe().booleanValue()) {
            this.checkSubscribe(openId);
        }
        boolean paid = false;
        ArrayList<Pay> tokenPayList = null;
        ActivityFee activityFee = null;
        if (activity.getIsEnableFee().booleanValue()) {
            activityFee = this.activityFeeService.selectByActivityId(activityId);
            sign.setPrice(activityFee.getPrice());
            if (StringUtil.isBlank((String)activity.getPayWay()) || StringUtil.equals((String)activity.getPayWay(), (String)PayWayEnum.ONLINE.value())) {
                int point;
                tokenPayList = new ArrayList<Pay>();
                String couponId = activitySign.getCouponId();
                if (StringUtil.isNotBlank((String)couponId)) {
                    Coupon coupon = this.couponService.selectAvailableCouponForActivity(couponId, memberId, activityFee.getPrice().intValue(), sign.getSourceId(), activity.getCategoryId());
                    Shift.throwsIfNull((Object)coupon, (String)"\u9009\u62e9\u7684\u4f18\u60e0\u5238\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    String payMerchantId = EnvironmentUtil.getPayMerchantId((Environment)this.env);
                    Pay couponPay = this.payService.createByCoupon(coupon.getAmount().intValue(), couponId, sign.getId(), OrderTypeEnum.ACTIVITY.value(), activity.getTitle(), activity.getAppId(), memberId, payMerchantId);
                    tokenPayList.add(couponPay);
                }
                int tokenPaidAmount = 0;
                if (tokenPayList != null && tokenPayList.size() > 0) {
                    for (Pay pay : tokenPayList) {
                        tokenPaidAmount += pay.getAmount().intValue();
                    }
                }
                int price = activityFee.getPrice();
                int n = point = activityFee.getPoint() == null ? 0 : activityFee.getPoint();
                if (price > 0 && point <= 0) {
                    if (tokenPaidAmount >= activityFee.getPrice() && point <= 0) {
                        paid = true;
                    }
                } else if (price <= 0 && point > 0) {
                    paid = false;
                } else if (tokenPaidAmount >= activityFee.getPrice() && point <= 0) {
                    paid = true;
                }
                sign.setPayAmount(Integer.valueOf(tokenPaidAmount));
                if (activity.getIsOneSignMany().booleanValue()) {
                    Shift.throwsIfInvalid((sign.getOneSignManyNum() == null || sign.getOneSignManyNum() <= 0 ? 1 : 0) != 0, (String)"\u8bf7\u5408\u7406\u586b\u5199\u62a5\u540d\u4eba\u6570");
                    Shift.throwsIfInvalid((sign.getOneSignManyNum() > activity.getOneSignManyMaxNum() ? 1 : 0) != 0, (String)("\u4e00\u4eba\u6700\u591a\u62a5\u540d" + activity.getOneSignManyMaxNum() + "\u4eba"));
                    sign.setAmount(Integer.valueOf(sign.getPrice() * sign.getOneSignManyNum() - sign.getPayAmount()));
                } else {
                    sign.setAmount(Integer.valueOf(sign.getPrice() - sign.getPayAmount()));
                }
            } else {
                sign.setPayAmount(Integer.valueOf(0));
                sign.setIsPay(Boolean.valueOf(false));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(shareMemberId = activitySign.getDstr())) && StringUtils.isNotBlank((CharSequence)activitySign.getShareMemberId())) {
            Shift.throwsIfInvalid((!shareMemberId.equals(activitySign.getShareMemberId()) ? 1 : 0) != 0, (String)"\u5206\u4eab\u8005\u4e0d\u4e00\u81f4");
        }
        if (StringUtil.isNotBlank((String)shareMemberId)) {
            Member shareMember = this.memberService.selectById(shareMemberId);
            if (shareMember == null) {
                sign.setShareMemberId(null);
            } else {
                sign.setShareMemberId(shareMemberId);
            }
        }
        String channelCodeId = activitySign.getChannelCodeId();
        String channelCode = activitySign.getChc();
        ChannelCode code = null;
        if (StringUtil.isNotBlank((String)channelCodeId)) {
            code = (ChannelCode)this.channelCodeService.selectById((Object)channelCodeId);
        } else if (StringUtil.isNotBlank((String)channelCode)) {
            code = this.channelCodeService.selectByCode(channelCode, appId);
        }
        if (code == null) {
            String platformChannelCode = this.env.getProperty("system.channelCode");
            sign.setShareCode(platformChannelCode);
        } else {
            sign.setShareCode(code.getCode());
            sign.setChannelCodeId(code.getId());
            sign.setChannelId(code.getChannelId());
            Channel channel = (Channel)this.channelService.selectById((Object)code.getChannelId());
            sign.setChannel(channel.getChannelName());
            sign.setSubChannel(code.getName());
            logger.error("\u62a5\u540d\u5df2\u8bbe\u7f6e\u6e20\u9053\uff1a{}\uff0c\u5b50\u6e20\u9053\uff1a{}", (Object)channel.getChannelName(), (Object)code.getName());
        }
        try {
            MemberAccount miniProgramAccount;
            logger.error("\u62a5\u540d\u8005openid->{}", (Object)openId);
            String upperOpenId = this.shareOpenIdChainService.getRealUpperOpenId(openId);
            logger.error("\u62a5\u540d\u8005\u7684\u63a8\u5e7f\u8005openid->{}", (Object)upperOpenId);
            if (StringUtil.isNotBlank((String)upperOpenId) && (miniProgramAccount = this.memberAccountService.selectByUsername(upperOpenId)) != null) {
                String sharerId = miniProgramAccount.getMemberId();
                logger.error("\u62a5\u540d\u8005\u7684\u63a8\u5e7f\u8005id->{}", (Object)sharerId);
                if (StringUtil.isNotBlank((String)sharerId)) {
                    Sharer sharer = (Sharer)this.sharerService.selectById((Object)sharerId);
                    sign.setSharerName(sharer.getName());
                    sign.setSharerId(sharer.getId());
                    logger.error("\u62a5\u540d\u8005\u7684\u63a8\u5e7f\u8005name->{}", (Object)sharer.getName());
                }
            }
        }
        catch (Exception upperOpenId) {
            // empty catch block
        }
        Distributer upperDistributer = this.distributerService.selectByMemberId(memberId);
        if (upperDistributer != null && StringUtil.equals((String)upperDistributer.getStatus(), (String)DistributerStatusEnum.AUDITED.value())) {
            activitySign.getSign().setDistributerId(upperDistributer.getId());
        } else {
            activitySign.getSign().setDistributerId(null);
        }
        signSetting.setPreSignNum(signSetting.getPreSignNum() + sign.getNum());
        if (airboneCheckin) {
            sign.setStatus(SignStatusEnum.SIGN.getIndex());
            if (activity.getIsEnableFee().booleanValue()) {
                sign.setStatus(SignStatusEnum.NOT_PAY.getIndex());
            }
        } else {
            boolean auditAfterPay = signSetting.getAuditAfterPay();
            boolean payAfterAudit = signSetting.getPayAfterAudit();
            if (!signSetting.getIsEnableAudit().booleanValue() && !activity.getIsEnableFee().booleanValue()) {
                sign.setStatus(SignStatusEnum.SIGN.getIndex());
            } else if (activity.getIsEnableFee().booleanValue() && !signSetting.getIsEnableAudit().booleanValue()) {
                sign.setStatus(SignStatusEnum.NOT_PAY.getIndex());
            } else if (signSetting.getIsEnableAudit().booleanValue()) {
                if (auditAfterPay) {
                    sign.setStatus(SignStatusEnum.NOT_AUDIT.getIndex());
                }
                if (payAfterAudit) {
                    sign.setStatus(SignStatusEnum.NOT_PAY.getIndex());
                }
            }
        }
        final ActivityPointSetting activityScore = this.activityScoreService.selectByActivityId(sign.getSourceId());
        final boolean thisPaid = paid;
        final ArrayList<Pay> thisTokenPayList = tokenPayList;
        String lockKey = activity.getId() + member.getId();
        SignResponse signResponse = (SignResponse)this.simpleRedisTemplate.doInLock(lockKey, (LockCallBack)new LockCallBack<SignResponse>(){

            public SignResponse exec(String key) {
                logger.info("\u8fdb\u5165\u9501-------->{}", (Object)key);
                Boolean exist = ActivityProvider.this.activitySignService.selectExsist(member.getId(), sign.getSourceId());
                Shift.throwsIfInvalid((boolean)exist, (String)"\u60a8\u5df2\u7ecf\u62a5\u8fc7\u540d\u4e86");
                return ActivityProvider.this.activitySignService.sign(activity, activitySign, signSetting, member, thisPaid, thisTokenPayList, activityScore);
            }
        });
        String signId = signResponse.getSignId();
        this.experienceAsync.addExperience(LevelTypeEnum.STUDY.getIndex().intValue(), "activity_sign", memberId, signId, member.getAppId());
        if (StringUtil.isNotBlank((String)activitySign.getShareMemberId())) {
            LevelExperience levelExperience = (LevelExperience)this.levelExperienceService.select(JpaCriteria.builder().eq("source", (Object)"activity_share_sign").eq("type", (Object)LevelTypeEnum.STUDY.getIndex()).eq("memberId", (Object)activitySign.getShareMemberId()).eq("appId", (Object)member.getAppId()).eq("fromId", (Object)signId));
            if (levelExperience == null) {
                this.experienceAsync.addExperience(LevelTypeEnum.INFLUENCE.getIndex().intValue(), "activity_share_sign", activitySign.getShareMemberId(), signId, member.getAppId());
            } else {
                logger.info("\u67e5\u8be2\u7ecf\u9a8c\u6d41\u6c34\uff0c\u5206\u4eab\u8005\u4e0d\u52a0\u7ecf\u9a8c");
            }
        }
        ActivityResponseParam responseParam = new ActivityResponseParam();
        responseParam.setId(signId);
        responseParam.setMemberId(memberId);
        responseParam.setActivity(activity);
        responseParam.setSignPoint(signResponse.getGivePoint());
        return responseParam;
    }

    public void cancel(String id, Boolean isMobile) {
        Sign activitySign = (Sign)this.signService.selectById((Object)id);
        Shift.throwsIfNull((Object)activitySign, (String)"\u62a5\u540d\u4e0d\u5b58\u5728");
        Shift.throwsIfInvalid((activitySign.getFirstCheckinTime() != null ? 1 : 0) != 0, (String)"\u60a8\u5df2\u7b7e\u5230\uff0c\u65e0\u6cd5\u53d6\u6d88");
        Shift.throwsIfInvalid((activitySign.getStatus() == SignStatusEnum.CANCEL.getIndex() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88");
        ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)activitySign.getSourceId())));
        if (isMobile.booleanValue()) {
            Shift.throwsIfInvalid((activitySignSetting.getIsEnableUnsign() == false ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u4e0d\u80fd\u53d6\u6d88");
            Shift.throwsIfInvalid((boolean)new Date().after(activitySignSetting.getUnsignEndTime()), (String)"\u5df2\u8fc7\u53d6\u6d88\u65f6\u95f4");
        }
        this.activitySignService.cancel(activitySign, activitySignSetting);
    }

    private void checkSubscribe(String openId) {
        String wechatAppId = this.wechatAccessTokenHelper.getAppId();
        String accessToken = this.wechatAccessTokenHelper.getToken(wechatAppId, false);
        Shift.throwsIfInvalid((!this.wechatFansHelper.isSubscribe(accessToken, openId) ? 1 : 0) != 0, (String)"\u8bf7\u5148\u5173\u6ce8\u516c\u4f17\u53f7\u540e\u518d\u62a5\u540d");
    }
}

