/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.scheduler;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.ActivitySignFile;
import com.wego168.activity.service.ActivitySignFileService;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.service.FileServerService;
import com.wego168.util.StringUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ActivitySignFileTask {
    private static final Logger log = LoggerFactory.getLogger(ActivitySignFileTask.class);
    @Autowired
    private ActivitySignFileService activitySignFileService;
    @Autowired
    private FileServerService fileServerService;
    @Value(value="${activity.sign.file}")
    private String basePath;
    private final String ACTIVITY = "activity";

    @Scheduled(cron="0 0/1 * * * ?")
    public void deleteActivitySignFile() {
        List<ActivitySignFile> activitySignFiles = this.activitySignFileService.getThreeDaysAge();
        if (activitySignFiles.size() == 0) {
            return;
        }
        for (ActivitySignFile activitySignFile : activitySignFiles) {
            String path = activitySignFile.getLocalPath();
            if (!StringUtil.contains((String)path, (String)"activity")) continue;
            log.error("\u5220\u9664\u4e09\u5929\u4e4b\u524d\u6d3b\u52a8\u62a5\u540d\u6253\u5305\u9644\u4ef6->{}", (Object)path);
            try {
                File file = new File(path);
                if (!file.exists()) {
                    this.activitySignFileService.deleteFile(activitySignFile);
                    continue;
                }
                FileUtils.deleteDirectory((File)file);
                this.activitySignFileService.deleteFile(activitySignFile);
                FileServer fileServer = (FileServer)this.fileServerService.select(JpaCriteria.builder().eq("appId", (Object)"0"));
                FileUploadUtil.deleteOnCos((String)activitySignFile.getCosPath(), (FileServer)fileServer);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u5931\u8d25->{}", (Throwable)e);
            }
        }
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void deleteFileFolder() {
        if (!StringUtil.contains((String)this.basePath, (String)"activity")) {
            return;
        }
        File file = new File(this.basePath);
        File[] files = file.listFiles();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            for (File f : files) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(f.lastModified());
                cal.add(5, 3);
                if (!StringUtil.equals((String)formatter.format(cal.getTime()), (String)formatter.format(new Date()))) continue;
                log.error("\u5220\u96643\u5929\u4e4b\u524dactivity\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u5939->{}", (Object)f.getAbsolutePath());
                FileUtils.deleteDirectory((File)f);
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u53d1\u751f\u9519\u8bef->{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

