/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.scheduler;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.enums.ActivityTypeEnum;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.task.ActivityNotification;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.config.ServerConfig;
import com.wego168.base.domain.App;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.CheckinStatusEnum;
import com.wego168.base.enums.SignEntryTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.service.AppService;
import com.wego168.base.service.SignService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.InformationService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.SimpleJackson;
import com.wego168.wechat.api.IWechatAccessToken;
import com.wego168.wechat.api.IWechatMessage;
import com.wego168.wx.component.WxMsgTemplateSender;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.domain.WxMsgTemplate;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.model.WxMsgTemplateParamter;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.service.WxMsgTemplateService;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AsyncTask {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private IWechatAccessToken wechatAccessTokenHelper;
    @Autowired
    private IWechatMessage wechatMessageHelper;
    @Autowired
    private ServerConfig serverConfig;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private SignService signService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private WxMsgTemplateSender wxMsgTemplateSender;
    @Autowired
    private MemberService memberService;
    @Autowired
    private AppService appService;
    @Autowired
    private WxMsgTemplateService wxMsgTemplateService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ActivityNotification activityNotification;
    private static final Logger logger = LoggerFactory.getLogger(AsyncTask.class);
    private final String ACCESSTOKEN_KEY = "accessToken_entryType_";
    private final String URL_KEY = "url_entryType_";
    private final String ACTIVITYNOTPAY = "ACTIVITY_NOT_PAY";
    private final String ACTIVITYSIGNSTATUS = "ACTIVITY_SIGN_STATUS";

    private Map<String, String> getTokenAndUrlMap(Map<String, String> map, String activityId, String appId, Integer entryType) {
        Integer wxAppServiceType = entryType == null ? WxAppServiceTypeEnum.SERVICE.value() : entryType.intValue();
        WxApp wxApp = (WxApp)this.wxAppService.select(JpaCriteria.builder().eq("appId", (Object)appId).eq("serviceType", (Object)wxAppServiceType));
        if (wxApp == null) {
            wxApp = (WxApp)this.wxAppService.select(JpaCriteria.builder().eq("appId", (Object)"c068da87d57b409b87b2b885d6841bd9").eq("serviceType", (Object)wxAppServiceType));
        }
        logger.error("wxApp\uff1a{}", (Object)SimpleJackson.toJson((Object)wxApp));
        logger.error("appId\uff1a{}", (Object)SimpleJackson.toJson((Object)appId));
        String wxappId = wxApp.getWxAppId();
        String wxAppSecret = wxApp.getWxAppSecret();
        String accessToken = "";
        String url = "";
        App app = this.appService.selectByAppId(appId);
        logger.error("app->{}", (Object)app.getId());
        if (IntegerUtil.equals((Integer)wxAppServiceType, (Integer)WxAppServiceTypeEnum.SERVICE.value())) {
            url = this.serverConfig.getDomain() + "/" + app.getCode() + "/mobile/POUND/activity/detail?wo=1&wot=2&woacm=1&mpl=1&id=" + activityId;
            accessToken = this.wechatAccessTokenHelper.getToken(wxappId, false);
        } else if (IntegerUtil.equals((Integer)wxAppServiceType, (Integer)WxAppServiceTypeEnum.MINI_PROGRAM.value())) {
            url = "pages/activityDetail/activityDetail?id=" + activityId;
            accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
        }
        map.put("accessToken_entryType_" + wxAppServiceType, accessToken);
        map.put("url_entryType_" + wxAppServiceType, url);
        return map;
    }

    @Async
    public void sendMsg(Activity activity, ActivitySignSetting activitySignSetting, List<Sign> signList) {
        try {
            Map<String, String> tokenAndUrlMap = new HashMap<String, String>();
            String appId = activity.getAppId();
            String msg = "";
            String dateTime = DateTimeUtil.format((Date)activity.getStartTime(), (String)"yyyy-MM-dd HH:mm") + "--" + DateTimeUtil.format((Date)activity.getEndTime(), (String)"yyyy-MM-dd HH:mm");
            String title = activity.getTitle();
            String place = activity.getPlace();
            for (Sign sign : signList) {
                logger.error("\u53d1\u9001\u62a5\u540d\u901a\u77e5 -> {}", (Object)sign.getId());
                WxApp wxApp = null;
                String openId = "";
                Integer entryType = sign.getEntryType() == null ? WxAppServiceTypeEnum.SERVICE.value() : sign.getEntryType().intValue();
                if (IntegerUtil.equals((Integer)entryType, (Integer)WxAppServiceTypeEnum.MINI_PROGRAM.value())) {
                    wxApp = this.wxAppService.selectByAppId(appId, entryType.intValue());
                    openId = this.memberAccountService.selectMiniProgramAccount(sign.getMemberId()).getUsername();
                } else {
                    wxApp = this.wxAppService.selectByAppId(appId, WxAppServiceTypeEnum.SERVICE.value());
                    if (wxApp == null) {
                        WxApp app = this.wxAppService.selectByAppId("c068da87d57b409b87b2b885d6841bd9", WxAppServiceTypeEnum.SERVICE.value());
                        appId = app.getAppId();
                    }
                    openId = this.memberAccountService.selectWechatAccount(sign.getMemberId()).getUsername();
                }
                if (!tokenAndUrlMap.containsKey("accessToken_entryType_" + entryType)) {
                    tokenAndUrlMap = this.getTokenAndUrlMap(tokenAndUrlMap, activity.getId(), appId, entryType);
                }
                String accessToken = (String)tokenAndUrlMap.get("accessToken_entryType_" + entryType);
                String url = tokenAndUrlMap.get("url_entryType_" + entryType);
                WxMsgTemplateParamter paramter = null;
                if (entryType.equals(SignEntryTypeEnum.MINI_PROGRAM.value())) {
                    MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(sign.getMemberId());
                    openId = memberAccount.getUsername();
                    paramter = WxMsgTemplateParamter.builder((String)appId, (String)"SIGN_STATUS", Arrays.asList(openId), (String)"");
                    paramter.setServiceType(entryType);
                    paramter.setAccessToken(accessToken);
                    paramter.put((Object)"title", (Object)activity.getTitle());
                    paramter.put((Object)"status", (Object)SignStatusEnum.getNameByIndex((Integer)sign.getStatus()));
                    paramter.put((Object)"time", (Object)DateTimeUtil.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
                    this.wxMsgTemplateSender.sendTemplate(paramter);
                    this.cowebSendMsg(activity, activitySignSetting, sign);
                }
                paramter = WxMsgTemplateParamter.builder((String)appId, (String)"ACTIVITY_SIGN_STATUS", Arrays.asList(openId), (String)url);
                paramter.setAccessToken(accessToken);
                paramter.setServiceType(entryType);
                if (SignStatusEnum.NOT_PAY.getIndex().equals(sign.getStatus())) {
                    msg = activitySignSetting.getAuditPassMsg();
                    if (activitySignSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                        WxMsgTemplate wxMsgTemplate = this.wxMsgTemplateService.selectByType("ACTIVITY_NOT_PAY", Integer.valueOf(WxAppServiceTypeEnum.SERVICE.value()), appId);
                        if (wxMsgTemplate != null) {
                            paramter = WxMsgTemplateParamter.builder((String)appId, (String)"ACTIVITY_NOT_PAY", Arrays.asList(openId), (String)url);
                        }
                        paramter.set("detail", (Object)msg).set("payAmount", (Object)(new DecimalFormat("##.##").format(sign.getAmount().doubleValue() / 100.0) + "\u5143")).set("place", (Object)place).set("status", (Object)SignStatusEnum.NOT_PAY.getName()).set("name", (Object)title).set("time", (Object)dateTime).set("remark", (Object)msg);
                        this.wxMsgTemplateSender.sendTemplate(paramter);
                    }
                    if (!activitySignSetting.getIsEnableWxRemind().booleanValue()) continue;
                    this.wechatMessageHelper.sendCustomMessage(accessToken, openId, "<a href=\\\"" + url + "\\\">\u60a8\u6709\u4e00\u6761\u5f85\u652f\u4ed8\u8ba2\u5355,\u8bf7\u5c3d\u5feb\u5b8c\u6210\u652f\u4ed8</a>");
                    continue;
                }
                if (SignStatusEnum.AUDIT_NOT_PASS.getIndex().equals(sign.getStatus())) {
                    msg = activitySignSetting.getAuditNotPassMsg();
                    if (activitySignSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                        paramter.set("detail", (Object)msg).set("place", (Object)place).set("status", (Object)SignStatusEnum.AUDIT_NOT_PASS.getName()).set("name", (Object)title).set("time", (Object)dateTime).set("remark", (Object)msg);
                        this.wxMsgTemplateSender.sendTemplate(paramter);
                    }
                    if (!activitySignSetting.getIsEnableWxRemind().booleanValue()) continue;
                    this.wechatMessageHelper.sendCustomMessage(accessToken, openId, msg + " <a href=\\\"" + url + "\\\">\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>");
                    continue;
                }
                if (SignStatusEnum.NOT_AUDIT.getIndex().equals(sign.getStatus())) {
                    if (activitySignSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                        paramter.set("detail", (Object)"\u60a8\u7684\u62a5\u540d\u5f85\u4e3b\u529e\u65b9\u5ba1\u6838").set("place", (Object)place).set("status", (Object)SignStatusEnum.NOT_AUDIT.getName()).set("name", (Object)title).set("time", (Object)dateTime).set("remark", (Object)msg);
                        this.wxMsgTemplateSender.sendTemplate(paramter);
                    }
                    if (!activitySignSetting.getIsEnableWxRemind().booleanValue()) continue;
                    this.wechatMessageHelper.sendCustomMessage(accessToken, openId, "\u60a8\u7684\u62a5\u540d\u6b63\u5728\u7b49\u5f85\u5ba1\u6838  <a href=\\\"" + url + "\\\">\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>");
                    continue;
                }
                if (!SignStatusEnum.SIGN.getIndex().equals(sign.getStatus())) continue;
                msg = activitySignSetting.getSignMsg();
                if (activitySignSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                    paramter.set("detail", (Object)msg).set("place", (Object)place).set("status", (Object)SignStatusEnum.SIGN.getName()).set("name", (Object)title).set("time", (Object)dateTime).set("remark", (Object)msg);
                    logger.error("\u62a5\u540d\u6210\u529f\u6d88\u606f\u53c2\u6570->{}", (Object)paramter);
                    this.wxMsgTemplateSender.sendTemplate(paramter);
                }
                if (!activitySignSetting.getIsEnableWxRemind().booleanValue()) continue;
                this.wechatMessageHelper.sendCustomMessage(accessToken, openId, msg + " <a href=\\\"" + url + "\\\">\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Async
    public void sendCheckinMsg(Integer status, CheckinSetting checkinSetting, String openId, Sign sign) {
        WxMsgTemplateParamter paramter;
        if (!checkinSetting.getIsEnableRemindMsg().booleanValue()) {
            return;
        }
        Activity activity = (Activity)((Object)this.activityService.selectById(checkinSetting.getSourceId()));
        String appId = activity.getAppId();
        String url = this.serverConfig.getDomain() + "/" + ((App)this.simpleRedisTemplate.get(appId, App.class)).getCode() + "/mobile/POUND/activity/detail?wo=1&wot=2&woacm=1&mpl=1&id=" + activity.getId();
        String msg = "";
        String dateTime = DateTimeUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        String title = activity.getTitle();
        String place = activity.getPlace();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, WxAppServiceTypeEnum.SERVICE.value());
        if (wxApp == null) {
            WxApp app = this.wxAppService.selectByAppId("c068da87d57b409b87b2b885d6841bd9", WxAppServiceTypeEnum.SERVICE.value());
            appId = app.getAppId();
        }
        Map<String, String> tokenAndUrlMap = new HashMap<String, String>();
        Integer entryType = WxAppServiceTypeEnum.SERVICE.value();
        if (sign != null) {
            entryType = sign.getEntryType() == null ? WxAppServiceTypeEnum.SERVICE.value() : sign.getEntryType().intValue();
        }
        if (!tokenAndUrlMap.containsKey("accessToken_entryType_" + entryType)) {
            tokenAndUrlMap = this.getTokenAndUrlMap(tokenAndUrlMap, activity.getId(), appId, entryType);
        }
        String accessToken = (String)tokenAndUrlMap.get("accessToken_entryType_" + entryType);
        if (entryType.equals(SignEntryTypeEnum.MINI_PROGRAM.value())) {
            logger.error("\u53d1\u9001\u5c0f\u7a0b\u5e8f\u6a21\u677f\u901a\u77e5");
            MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(sign.getMemberId());
            openId = memberAccount.getUsername();
            Member member = this.memberService.selectById(sign.getMemberId());
            if (CheckinStatusEnum.SUCCESS.getIndex().equals(status)) {
                logger.error("\u7b7e\u5230\u6210\u529f");
                WxMsgTemplateParamter paramter2 = WxMsgTemplateParamter.builder((String)appId, (String)"CHECKIN_SUCCESS", Arrays.asList(openId), (String)"");
                paramter2.setAccessToken(accessToken);
                paramter2.setServiceType(entryType);
                paramter2.put((Object)"name", (Object)member.getName());
                paramter2.put((Object)"time", (Object)DateTimeUtil.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
                Bootmap bootmap = this.wxMsgTemplateSender.sendTemplate(paramter2);
                logger.error("\u53d1\u9001\u7ed3\u679c->{}", (Object)bootmap);
            } else {
                logger.error("\u7b7e\u5230\u5931\u8d25");
                WxMsgTemplateParamter paramter3 = WxMsgTemplateParamter.builder((String)appId, (String)"CHECKIN_FAIL", Arrays.asList(openId), (String)("pagesCommon/activity/detail/index?activityId=" + sign.getSourceId()));
                paramter3.setAccessToken(accessToken);
                paramter3.setServiceType(entryType);
                paramter3.put((Object)"name", (Object)member.getName());
                paramter3.put((Object)"time", (Object)DateTimeUtil.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
                Bootmap bootmap = this.wxMsgTemplateSender.sendTemplate(paramter3);
                logger.error("\u53d1\u9001\u7ed3\u679c->{}", (Object)bootmap);
            }
        }
        if (CheckinStatusEnum.SUCCESS.getIndex().equals(status) || CheckinStatusEnum.NOT_SIGN.getIndex().equals(status)) {
            msg = CheckinStatusEnum.SUCCESS.getIndex().equals(status) ? checkinSetting.getCheckinMsg() : checkinSetting.getCheckinBySuddenMsg();
            if (checkinSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                paramter = WxMsgTemplateParamter.builder((String)appId, (String)"CHECKIN_SUCCESS", Arrays.asList(openId), (String)url);
                paramter.setAccessToken(accessToken);
                paramter.setServiceType(entryType);
                paramter.set("detail", (Object)"\u606d\u559c\u60a8,\u7b7e\u5230\u6210\u529f").set("title", (Object)title).set("place", (Object)place).set("msg", (Object)msg).set("time", (Object)dateTime).set("remark", (Object)"\u6b22\u8fce\u60a8\u7684\u5230\u6765");
                this.wxMsgTemplateSender.sendTemplate(paramter);
            }
            if (checkinSetting.getIsEnableWxRemind().booleanValue()) {
                this.wechatMessageHelper.sendCustomMessage(accessToken, openId, msg);
            }
        }
        if (CheckinStatusEnum.FAIL.getIndex().equals(status)) {
            msg = checkinSetting.getCheckinNotPassMsg();
            if (checkinSetting.getIsEnableWxTemplateRemind().booleanValue()) {
                paramter = WxMsgTemplateParamter.builder((String)appId, (String)"CHECKIN_FAIL", Arrays.asList(openId), (String)url);
                paramter.setAccessToken(accessToken);
                paramter.setServiceType(entryType);
                paramter.set("detail", (Object)title).set("msg", (Object)msg).set("title", (Object)title).set("place", (Object)place).set("time", (Object)dateTime).set("remark", (Object)"\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458");
                this.wxMsgTemplateSender.sendTemplate(paramter);
            }
            if (checkinSetting.getIsEnableWxRemind().booleanValue()) {
                this.wechatMessageHelper.sendCustomMessage(accessToken, openId, msg);
            }
        } else if (CheckinStatusEnum.REPEAT.getIndex().equals(status)) {
            this.wechatMessageHelper.sendCustomMessage(accessToken, openId, "\u60a8\u5df2\u7b7e\u5230\uff0c\u8bf7\u52ff\u91cd\u590d\u7b7e\u5230");
        }
    }

    private void cowebSendMsg(Activity activity, ActivitySignSetting activitySignSetting, Sign sign) {
        if (ActivityTypeEnum.ADMIN.getIndex().equals(activity.getType())) {
            logger.error("\u975e\u63a5\u9f99\u6d3b\u52a8{}", (Object)activity.getId());
            return;
        }
        String appId = sign.getAppId();
        Integer wxAppServiceType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        WxApp wxApp = this.wxAppService.selectByAppId(appId, wxAppServiceType.intValue());
        logger.error("COWEB_SIGN_STATUS : " + wxApp.getWxAppId());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6ewxApp");
        String wxappId = wxApp.getWxAppId();
        String wxAppSecret = wxApp.getWxAppSecret();
        String accessToken = this.wechatAccessTokenHelper.getToken(wxappId, wxAppSecret, false);
        String sourceId = sign.getSourceId();
        if (IntegerUtil.equals((Integer)ActivityTypeEnum.ADMIN.getIndex(), (Integer)activity.getType())) {
            logger.error("\u975e\u63a5\u9f99\u6d3b\u52a8{}", (Object)activity.getId());
            return;
        }
        Member member = this.memberService.selectById(sign.getMemberId());
        Information information = (Information)this.informationService.select(JpaCriteria.builder().eq("sourceId", (Object)sourceId));
        String url = "pagesCoWebs/information/relay-detail/index?id=" + information.getId() + "&sourceId=" + sourceId;
        List signs = this.signService.selectList(JpaCriteria.builder().eq("sourceType", (Object)SourceTypeEnum.ACTIVITY.getIndex()).eq("sourceId", (Object)sign.getSourceId()).eq("status", (Object)SignStatusEnum.SIGN.getIndex()).eq("appId", (Object)activity.getAppId()));
        String openId = this.memberAccountService.selectMiniProgramAccount(information.getMemberId()).getUsername();
        WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)appId, (String)"COWEB_SIGN_STATUS", Arrays.asList(openId), (String)url);
        paramter.setAccessToken(accessToken);
        paramter.setServiceType(wxAppServiceType);
        paramter.put((Object)"title", (Object)information.getTitle());
        paramter.put((Object)"name", (Object)member.getName());
        paramter.put((Object)"time", (Object)DateTimeUtil.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"));
        paramter.put((Object)"status", (Object)SignStatusEnum.getNameByIndex((Integer)sign.getStatus()));
        paramter.put((Object)"num", (Object)signs.size());
        this.wxMsgTemplateSender.sendTemplate(paramter);
    }
}

