/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.scheduler;

import com.wego168.activity.domain.Activity;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.domain.Sign;
import com.wego168.base.service.SignService;
import com.wego168.domain.BaseDomain;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.util.GuidGenerator;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.enums.PayGateWayCodeEnum;
import com.wego168.wxpay.enums.PaySceneEnum;
import com.wego168.wxpay.interfaces.IPayAndRefund;
import com.wego168.wxpay.model.response.RefundResponse;
import com.wego168.wxpay.service.PayService;
import com.wego168.wxpay.service.WxpayConfigService;
import com.wego168.wxpay.util.PayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class RefundTask {
    private static final Logger log = LoggerFactory.getLogger(RefundTask.class);
    @Autowired
    @Qualifier(value="wechatPayHelper")
    private IPayAndRefund wechatPayHelper;
    @Autowired
    private Environment env;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private PayService payService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private SignService signService;
    @Autowired
    private ActivityService activityService;

    @Async
    public void refundAsync(Pay pay) {
        this.refund(pay);
    }

    public String refund(Pay pay) {
        log.error("\u6d3b\u52a8\u9000\u6b3e\t-> {}", (Object)pay);
        String wechatAppId = "";
        String merchantId = pay.getMerchantId();
        String merchentKey = "";
        String p12file = "";
        String appId = pay.getAppId();
        int merchantType = pay.getMerchantType();
        WxpayConfig wxPayConfig = this.wxpayConfigService.selectByAppIdAndMerchant(appId, merchantId, merchantType);
        if (wxPayConfig == null) {
            wxPayConfig = this.wxpayConfigService.selectByAppIdAndMerchant("c068da87d57b409b87b2b885d6841bd9", merchantId, merchantType);
        }
        wechatAppId = wxPayConfig.getMchAppId();
        merchentKey = wxPayConfig.getMchKey();
        p12file = this.env.getProperty("wechat.pay.p12file") + wxPayConfig.getCertPath();
        String refundId = GuidGenerator.generate();
        String channel = pay.getChannel();
        if (StringUtil.equals((String)channel, (String)PayGateWayCodeEnum.JOIN.description())) {
            refundId = refundId.substring(2);
            p12file = "http://x.wego168.com/wego168/api/v1/refund/join";
        }
        log.error("\u6d3b\u52a8\u9000\u6b3e\u8bf7\u6c42\u5546\u5bb6\u53c2\u6570\t->\twechatAppId\uff1a{}, merchentKey\uff1a {}, p12file\uff1a {}", new Object[]{wechatAppId, merchentKey, p12file});
        IPayAndRefund refundHelper = this.payUtil.determineRefundHelperByCode(channel);
        RefundResponse refundResponse = refundHelper.refund(wechatAppId, merchantId, merchentKey, p12file, pay.getId(), refundId, pay.getAmount().intValue(), pay.getAmount().intValue());
        log.error("\u6d3b\u52a8\u9000\u6b3e\u54cd\u5e94\u5185\u5bb9\t->\t{}", (Object)refundResponse);
        String signId = pay.getOrderId();
        Sign sign = (Sign)this.signService.selectById((Object)signId);
        Activity activity = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
        String title = "";
        title = StringUtil.isBlank((String)activity.getTitle()) ? "\u6d3b\u52a8\u62a5\u540d\u9000\u6b3e" : activity.getTitle();
        if (title.length() > 32) {
            title = title.substring(0, 32);
        }
        Pay refund = pay;
        refund.setRefundReferencePayId(pay.getId());
        refund.setOrderTitle(title);
        refund.setId(refundId);
        refund.setScene(Integer.valueOf(PaySceneEnum.REFUND.value()));
        refund.setStatus(Integer.valueOf(refundResponse.getRefundStatus()));
        refund.setAmount(pay.getAmount());
        refund.setCurrencyMessage(refundId);
        refund.setOutTradeNo(refundResponse.getMessage());
        BaseDomainUtil.initBaseDomain((BaseDomain)refund, (String)pay.getAppId());
        refund.setMerchantId(merchantId);
        this.payService.insert((Object)refund);
        return refundResponse.getMessage();
    }
}

