/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.service.ActivityPointSettingService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.OrderTypeEnum;
import com.wego168.base.service.AppAbilityService;
import com.wego168.member.domain.points.PointsFlow;
import com.wego168.member.enums.PointsBusinessTypeEnum;
import com.wego168.member.enums.PointsTypeEnum;
import com.wego168.member.persistence.points.PointsFlowMapper;
import com.wego168.member.service.impl.points.PointsFlowService;
import com.wego168.member.service.mq.PointsProduceSender;
import com.wego168.util.Checker;
import com.wego168.util.DateUtil;
import com.wego168.util.StringUtil;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayChannelEnum;
import com.wego168.wxpay.enums.PayCurrencyEnum;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.service.PayService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityPointService {
    @Autowired
    private PointsFlowMapper pointsFlowMapper;
    @Autowired
    private PointsFlowService pointsFlowService;
    @Autowired
    private AppAbilityService appAbilityService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityPointSettingService activityPointSettingService;
    @Autowired
    private PayService payService;
    @Autowired
    private PointsProduceSender pointsProduceSender;
    @Autowired
    private ActivitySignService activitySignService;
    private Logger logger = LoggerFactory.getLogger(ActivityPointService.class);

    public void giveActivitySignPoint(Sign sign, String activityTitle) {
        int signPoint;
        this.logger.error("give activity sign point->{}", (Object)activityTitle);
        ActivityPointSetting activityPoint = this.activityPointSettingService.selectByActivityId(sign.getSourceId());
        int n = signPoint = activityPoint != null ? activityPoint.getSignPoint() : 0;
        if (signPoint <= 0) {
            this.logger.error("give activity sign point: zero, activity->{}", (Object)activityTitle);
            return;
        }
        String appId = sign.getAppId();
        if (!this.activitySignPointIsOpen(appId)) {
            this.logger.error("give activity sign point: closed, appId->{}", (Object)appId);
            return;
        }
        String userId = sign.getMemberId();
        String businessId = sign.getId();
        String businessType = PointsBusinessTypeEnum.ACTIVITY_SIGN.value();
        String type = PointsTypeEnum.INCOME.value();
        PointsFlow pointsFlow = this.pointsFlowService.build(userId, signPoint, activityTitle, type, businessId, businessType, appId);
        this.pointsProduceSender.doSend(new PointsFlow[]{pointsFlow});
        this.logger.error("give activity sign point {}", (Object)signPoint);
    }

    @Async
    public void giveActivitySignPointAsync(Sign sign, String activityTitle) {
        this.giveActivitySignPoint(sign, activityTitle);
    }

    @Async
    public void giveActivityInviteSignPointAsync(Sign sign, String activityTitle) {
        this.giveActivityInviteSignPoint(sign, activityTitle);
    }

    @Async
    public void giveActivityCheckinPointAsync(Checkin checkin) {
        this.giveActivityCheckinPoint(checkin);
    }

    @Async
    public void deductActivitySignPointAsync(Sign sign) {
        this.deductActivitySignPoint(sign);
        this.deductActivityInviteSignPoint(sign.getId());
    }

    private void deductActivityInviteSignPoint(String signId) {
        JpaCriteria criteria = JpaCriteria.builder();
        String businessType = PointsBusinessTypeEnum.INVITE_ACTIVITY_SIGN.value();
        criteria.eq("businessType", (Object)businessType);
        criteria.eq("businessId", (Object)signId);
        String type = PointsTypeEnum.INCOME.value();
        criteria.eq("type", (Object)type);
        List inviteSignPointList = this.pointsFlowMapper.selectList(criteria);
        if (Checker.listNotEmpty((List)inviteSignPointList)) {
            for (PointsFlow inviteSignPoint : inviteSignPointList) {
                String appId = inviteSignPoint.getAppId();
                String activityTitle = inviteSignPoint.getDetail() + "-\u9080\u8bf7\u5956\u52b1\u53d6\u6d88";
                int points = -inviteSignPoint.getAmount().intValue();
                String deductType = PointsTypeEnum.DEDUCT.value();
                String userId = inviteSignPoint.getUserId();
                PointsFlow signPointsDeductFlow = this.pointsFlowService.build(userId, points, activityTitle, deductType, signId, businessType, appId);
                this.pointsFlowService.consume(new PointsFlow[]{signPointsDeductFlow});
            }
        }
    }

    public int giveShareActivityPoint(int point, String memberId, Activity activity) {
        String appId = activity.getAppId();
        if (this.activitySharePointIsOpen(appId)) {
            String businessId = activity.getId();
            String businessType = PointsBusinessTypeEnum.SHARE_ACTIVITY.value();
            String activityTitle = activity.getTitle();
            String type = PointsTypeEnum.INCOME.value();
            PointsFlow pointsFlow = this.pointsFlowService.build(memberId, point, activityTitle, type, businessId, businessType, appId);
            this.pointsProduceSender.doSend(new PointsFlow[]{pointsFlow});
            return point;
        }
        return 0;
    }

    public int sumTodayActivitySharePoint(String activityId, String memberId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("userId", (Object)memberId);
        criteria.eq("businessId", (Object)activityId);
        criteria.eq("businessType", (Object)PointsBusinessTypeEnum.SHARE_ACTIVITY.value());
        criteria.eq("type", (Object)PointsTypeEnum.INCOME.value());
        Date today0Clock = DateUtil.getToday0oClock();
        Date tomorrow0Clock = DateUtil.addDaysToDate((Date)today0Clock, (int)1);
        criteria.ge("createTime", (Object)today0Clock);
        criteria.lt("createTime", (Object)tomorrow0Clock);
        criteria.select("SUM(amount)");
        Integer totalAmount = (Integer)this.pointsFlowService.select(criteria, Integer.class);
        return totalAmount == null ? 0 : totalAmount;
    }

    private void deductActivitySignPoint(Sign sign) {
        String userId = sign.getMemberId();
        String businessId = sign.getId();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("userId", (Object)userId);
        criteria.eq("businessId", (Object)businessId);
        criteria.eq("businessType", (Object)PointsBusinessTypeEnum.ACTIVITY_SIGN.value());
        criteria.eq("appId", (Object)sign.getAppId());
        criteria.orderBy("createTime DESC");
        List list = this.pointsFlowMapper.selectList(criteria);
        if (Checker.listIsEmpty((List)list)) {
            return;
        }
        boolean deducted = false;
        int giveTimes = 0;
        int deductTimes = 0;
        PointsFlow recentSignPointsFlow = null;
        for (PointsFlow pointsFlow : list) {
            String type = pointsFlow.getType();
            if (StringUtil.equals((String)type, (String)PointsTypeEnum.INCOME.value())) {
                ++giveTimes;
                if (recentSignPointsFlow == null) {
                    recentSignPointsFlow = pointsFlow;
                }
            }
            if (!StringUtil.equals((String)type, (String)PointsTypeEnum.DEDUCT.value())) continue;
            ++deductTimes;
        }
        boolean bl = deducted = deductTimes >= giveTimes;
        if (deducted) {
            return;
        }
        if (recentSignPointsFlow != null) {
            String appId = sign.getAppId();
            String activityTitle = recentSignPointsFlow.getDetail();
            int points = -recentSignPointsFlow.getAmount().intValue();
            String type = PointsTypeEnum.DEDUCT.value();
            String businessType = PointsBusinessTypeEnum.ACTIVITY_SIGN.value();
            PointsFlow signPointsDeductFlow = this.pointsFlowService.build(userId, points, activityTitle, type, businessId, businessType, appId);
            this.pointsFlowService.consume(new PointsFlow[]{signPointsDeductFlow});
        }
    }

    @Transactional
    public void pointPayActivitySign(Sign signDb, String title, String memberId, int payPoint, String appId) {
        String type = PointsTypeEnum.CONSUME.value();
        String businessId = signDb.getId();
        String businessType = PointsBusinessTypeEnum.ACTIVITY_SIGN_PAY.value();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("businessId", (Object)businessId);
        criteria.eq("businessType", (Object)businessType);
        criteria.eq("type", (Object)type);
        criteria.eq("userId", (Object)memberId);
        List list = this.pointsFlowMapper.selectList(criteria);
        if (Checker.listNotEmpty((List)list)) {
            this.logger.error("{} point is paid", (Object)title);
            return;
        }
        PointsFlow pointsFlow = this.pointsFlowService.build(memberId, payPoint, title, type, businessId, businessType, appId);
        int orderType = OrderTypeEnum.ACTIVITY.value();
        this.deductPointAndSavePay(pointsFlow, orderType);
        this.activitySignService.updateSignPointPay(signDb, payPoint);
    }

    @Async
    public void returnActivitySignPointIfPaid(String signId, String memberId) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String type = PointsTypeEnum.CONSUME.value();
        String businessId = signId;
        String businessType = PointsBusinessTypeEnum.ACTIVITY_SIGN_PAY.value();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("businessId", (Object)businessId);
        criteria.eq("businessType", (Object)businessType);
        criteria.eq("type", (Object)type);
        criteria.eq("userId", (Object)memberId);
        List list = this.pointsFlowMapper.selectList(criteria);
        if (Checker.listIsEmpty((List)list)) {
            return;
        }
        PointsFlow pointsFlow = (PointsFlow)list.get(0);
        int returnPoint = Math.abs(pointsFlow.getAmount());
        this.pointsFlowService.refund(pointsFlow.getId(), returnPoint);
    }

    @Transactional
    private void deductPointAndSavePay(PointsFlow pointsFlow, int orderType) {
        this.pointsFlowService.consume(new PointsFlow[]{pointsFlow});
        String orderId = pointsFlow.getBusinessId();
        String title = pointsFlow.getDetail();
        String memberId = pointsFlow.getUserId();
        String appId = pointsFlow.getAppId();
        int mchType = ServiceTypeEnum.PROGRAM.id();
        int amount = Math.abs(pointsFlow.getAmount());
        Pay pointPay = this.payService.createByCashTrade(amount, orderId, orderType, title, appId, memberId, "point", mchType);
        pointPay.setCash(Boolean.valueOf(false));
        pointPay.setCurrency(Integer.valueOf(PayCurrencyEnum.SCR.value()));
        pointPay.setChannel(PayChannelEnum.OTHER.value());
        pointPay.setStatus(Integer.valueOf(PayStatusEnum.SUCCESS.value()));
        this.payService.insert((Object)pointPay);
    }

    private void giveActivityInviteSignPoint(Sign sign, String activityTitle) {
        int invitePoint;
        this.logger.error("give activity invite sign point->{}", (Object)activityTitle);
        ActivityPointSetting activityPoint = this.activityPointSettingService.selectByActivityId(sign.getSourceId());
        int n = invitePoint = activityPoint == null ? 0 : activityPoint.getInviteSignPoint();
        if (invitePoint <= 0) {
            this.logger.error("give activity invite sign point: zero, activity->{}", (Object)activityTitle);
            return;
        }
        String appId = sign.getAppId();
        if (!this.activitySignPointIsOpen(appId)) {
            this.logger.error("give activity invite sign point: closed, appId->{}", (Object)appId);
            return;
        }
        String sharerId = sign.getShareMemberId();
        if (StringUtil.isBlank((String)sharerId)) {
            this.logger.error("give activity invite sign point: no sharer");
            return;
        }
        String businessId = sign.getId();
        String businessType = PointsBusinessTypeEnum.INVITE_ACTIVITY_SIGN.value();
        String type = PointsTypeEnum.INCOME.value();
        PointsFlow pointsFlow = this.pointsFlowService.build(sharerId, invitePoint, activityTitle, type, businessId, businessType, appId);
        this.pointsProduceSender.doSend(new PointsFlow[]{pointsFlow});
    }

    private void giveActivityCheckinPoint(Checkin checkin) {
        String appId = checkin.getAppId();
        String activityId = checkin.getSourceId();
        ActivityPointSetting activityPointSetting = this.activityPointSettingService.selectByActivityId(activityId);
        if (activityPointSetting == null) {
            this.logger.error("give activity checkin point: zero, activity->{}", (Object)activityId);
            return;
        }
        int checkinPoint = activityPointSetting.getCheckinPoint();
        if (checkinPoint <= 0) {
            this.logger.error("give activity checkin point: zero, activity->{}", (Object)activityId);
            return;
        }
        if (!this.activityCheckinPointIsOpen(appId)) {
            this.logger.error("give activity checkin point: closed, appId->{}", (Object)appId);
            return;
        }
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        String userId = checkin.getMemberId();
        String businessId = checkin.getId();
        String businessType = PointsBusinessTypeEnum.ACTIVITY_CHECKIN.value();
        String type = PointsTypeEnum.INCOME.value();
        PointsFlow pointsFlow = this.pointsFlowService.build(userId, checkinPoint, activity.getTitle(), type, businessId, businessType, appId);
        this.pointsProduceSender.doSend(new PointsFlow[]{pointsFlow});
    }

    private boolean activitySignPointIsOpen(String appId) {
        String code = "score-activity-sign";
        Map abilityStatusMap = this.appAbilityService.selectAbilityStatus(appId, code);
        Boolean isOpen = (Boolean)abilityStatusMap.get(code);
        return isOpen == null ? false : isOpen;
    }

    private boolean activityCheckinPointIsOpen(String appId) {
        String code = "score-activity-checkin";
        Map abilityStatusMap = this.appAbilityService.selectAbilityStatus(appId, code);
        Boolean isOpen = (Boolean)abilityStatusMap.get(code);
        return isOpen == null ? false : isOpen;
    }

    private boolean activitySharePointIsOpen(String appId) {
        String code = "score-activity-share";
        Map abilityStatusMap = this.appAbilityService.selectAbilityStatus(appId, code);
        Boolean isOpen = (Boolean)abilityStatusMap.get(code);
        return isOpen == null ? false : isOpen;
    }
}

