/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.persistence.ActivityPointSettingMapper;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityPointSettingService
extends BaseService<ActivityPointSetting> {
    @Autowired
    private ActivityPointSettingMapper mapper;

    public CrudMapper<ActivityPointSetting> getMapper() {
        return this.mapper;
    }

    public ActivityPointSetting selectByActivityId(String activityId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("activityId", (Object)activityId);
        List list = this.mapper.selectList(criteria);
        if (Checker.listNotEmpty((List)list)) {
            return (ActivityPointSetting)list.get(0);
        }
        return null;
    }

    public void insertByActivity(ActivityPointSetting activityPoint, String activityId) {
        activityPoint.setActivityId(activityId);
        activityPoint.setId(SequenceUtil.createUuid());
        this.defaultZero(activityPoint);
        this.insert(activityPoint);
    }

    public void updateByActivity(ActivityPointSetting activityPoint) {
        this.defaultZero(activityPoint);
        this.updateSelective(activityPoint);
    }

    private void defaultZero(ActivityPointSetting activityPoint) {
        Integer sharePoint;
        Integer maxSharePointPerDay;
        Integer maxSharePoint;
        Integer inviteSignPoint;
        Integer signPoint;
        Integer checkinPoint = activityPoint.getCheckinPoint();
        if (checkinPoint == null) {
            activityPoint.setCheckinPoint(0);
        }
        if ((signPoint = activityPoint.getSignPoint()) == null) {
            activityPoint.setSignPoint(0);
        }
        if ((inviteSignPoint = activityPoint.getInviteSignPoint()) == null) {
            activityPoint.setInviteSignPoint(0);
        }
        if ((maxSharePoint = activityPoint.getMaxSharePoint()) == null) {
            activityPoint.setMaxSharePoint(0);
        }
        if ((maxSharePointPerDay = activityPoint.getMaxSharePointPerDay()) == null) {
            activityPoint.setMaxSharePointPerDay(0);
        }
        if ((sharePoint = activityPoint.getSharePoint()) == null) {
            activityPoint.setSharePoint(0);
        }
    }
}

