/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.domain.ActivityTag;
import com.wego168.activity.enums.ActivityComboPayPolicyEnum;
import com.wego168.activity.enums.ActivityStatusEnum;
import com.wego168.activity.model.response.DistributerActivityWebPageResponse;
import com.wego168.activity.persistence.ActivityMapper;
import com.wego168.activity.persistence.ActivitySignMapper;
import com.wego168.activity.persistence.ActivitySignSettingMapper;
import com.wego168.activity.persistence.ActivityTagMapper;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityPointSettingService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.activity.service.ActivityTagService;
import com.wego168.base.domain.CalendarEvent;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.CheckinTime;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.domain.WechatQrcode;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.service.CalendarEventService;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.ContentService;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.base.service.SignService;
import com.wego168.base.service.WechatQrcodeService;
import com.wego168.member.domain.MemberCalendarEvent;
import com.wego168.member.service.impl.MemberCalendarEventService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityService
extends BaseService<Activity> {
    @Autowired
    private CalendarEventService calendarEventService;
    @Autowired
    private MemberCalendarEventService memberCalendarEventService;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private ActivityPointSettingService activityPointSettingService;
    @Autowired
    private CheckinSettingService activityCheckinSettingService;
    @Autowired
    private SignDataSettingService signDataSettingService;
    @Autowired
    private ActivityTagService activityTagService;
    @Autowired
    private ActivityTagMapper activityTagMapper;
    @Autowired
    private ContentService contentService;
    @Autowired
    protected AuthenticationUser authenticationUser;
    @Autowired
    protected ActivitySignSettingMapper activitySignSettingMapper;
    @Autowired
    protected WechatQrcodeService wechatQrcodeService;
    @Autowired
    protected ConfigService configService;
    @Autowired
    protected ActivitySignMapper activitySignMapper;
    @Autowired
    private SignService signService;
    private static final Logger logger = LoggerFactory.getLogger(ActivityService.class);

    public CrudMapper<Activity> getMapper() {
        return this.activityMapper;
    }

    @Transactional
    public String insertActivity(Activity activity, List<WechatQrcode> wechatQrcodeList, List<CheckinSetting> checkinSettingList) {
        List<ActivityTag> activityTagList;
        List<SignDataSetting> signDataList;
        String activityId = activity.getId();
        activity.setId(activityId);
        activity.setCreateBy(this.authenticationUser.getUserId());
        activity.setIsRelease(false);
        activity.setStatus(ActivityStatusEnum.PREVIEW.getIndex());
        ActivitySignSetting activitySignSetting = activity.getActivitySignSetting();
        if (activitySignSetting != null) {
            activitySignSetting.setId(GuidGenerator.generate());
            activitySignSetting.setActivityId(activityId);
            activitySignSetting.setActivityItemId(activityId);
            activitySignSetting.setPreSignNum(0);
            activitySignSetting.setSignNum(0);
        }
        ActivityFee activityFee = new ActivityFee();
        activityFee.setId(GuidGenerator.generate());
        activityFee.setActivityId(activityId);
        if (activity.getIsEnableFee().booleanValue()) {
            Boolean distributerCommissionNeedAudit;
            Object sharerPoint;
            activityFee = activity.getActivityFee();
            activityFee.setId(GuidGenerator.generate());
            activityFee.setActivityId(activityId);
            Integer point = activityFee.getPoint();
            if (point == null) {
                activityFee.setPoint(0);
            } else {
                String comboPayPolicy = activityFee.getComboPayPolicy();
                if (StringUtil.isBlank((String)comboPayPolicy)) {
                    comboPayPolicy = ActivityComboPayPolicyEnum.ALL.value();
                }
                Checker.checkInRange((Object)((Object)ActivityComboPayPolicyEnum.get(comboPayPolicy)), (Object[])ActivityComboPayPolicyEnum.values(), (String)"\u9519\u8bef\u7684\u7ec4\u5408\u652f\u4ed8\u7b56\u7565");
                activityFee.setComboPayPolicy(comboPayPolicy);
            }
            Integer distributerCommission = activityFee.getDistributerCommission();
            if (distributerCommission == null) {
                activityFee.setDistributerCommission(0);
            }
            if ((sharerPoint = activityFee.getSharerPoint()) == null) {
                activityFee.setSharerPoint(0);
            }
            if ((distributerCommissionNeedAudit = activityFee.getDistributerCommissionNeedAudit()) == null) {
                activityFee.setDistributerCommissionNeedAudit(false);
            }
        }
        this.activityFeeService.insert((Object)activityFee);
        ActivityPointSetting activityScore = activity.getActivityPointSetting();
        if (activityScore != null) {
            this.activityPointSettingService.insertByActivity(activityScore, activityId);
        }
        if ((signDataList = activity.getSignDataSettingList()) != null && signDataList.size() > 0) {
            for (SignDataSetting signDataSetting : signDataList) {
                signDataSetting.setId(GuidGenerator.generate());
                signDataSetting.setSourceId(activityId);
                signDataSetting.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
            }
        }
        if ((activityTagList = activity.getActivityTagList()) != null && activityTagList.size() > 0) {
            for (ActivityTag activityTag : activityTagList) {
                activityTag.setId(GuidGenerator.generate());
                activityTag.setActivityId(activityId);
            }
        }
        Content content = new Content();
        content.setId(GuidGenerator.generate());
        content.setContent(activity.getContent());
        this.contentService.insert((Object)content);
        activity.setContentId(content.getId());
        CalendarEvent calendarEvent = new CalendarEvent();
        calendarEvent.setSourceId(activity.getId());
        calendarEvent.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        calendarEvent.setTitle(activity.getTitle());
        calendarEvent.setInfo(activity.getInfo());
        calendarEvent.setPlace(activity.getPlace());
        calendarEvent.setAddress(activity.getAddress());
        calendarEvent.setStartTime(activity.getStartTime());
        calendarEvent.setEndTime(activity.getEndTime());
        calendarEvent.setRemaindTitle(activitySignSetting.getRemaindTitle());
        calendarEvent.setRemaindInfo(activitySignSetting.getRemaindInfo());
        super.insert((Object)activity);
        this.activitySignSettingService.insert((Object)activitySignSetting);
        this.wechatQrcodeService.insertBatch(wechatQrcodeList);
        this.activityTagService.insertBatch(activityTagList);
        this.activityCheckinSettingService.insertBatch(checkinSettingList);
        this.signDataSettingService.insertBatch(signDataList);
        this.calendarEventService.insert((Object)calendarEvent);
        return activityId;
    }

    @Transactional
    public String updateActivity(Activity activity, Map<String, WechatQrcode> qrcodeMap, List<CheckinSetting> checkinSettingList) {
        CalendarEvent calendarEvent;
        Boolean sharerCommissionNeedAudit;
        Integer sharerCommission;
        Integer sharePoint;
        Boolean distributerCommissionNeedAudit;
        String id;
        String activityId = activity.getId();
        Content content = new Content();
        content.setId(activity.getContentId());
        content.setContent(activity.getContent());
        this.contentService.updateSelective((Object)content);
        ActivitySignSetting activitySignSettings = activity.getActivitySignSetting();
        this.activitySignSettingService.updateSelective((Object)activitySignSettings);
        if (activity.getStatus() == null) {
            activity.setStatus(ActivityStatusEnum.PREVIEW.getIndex());
        }
        if (activity.getIsRelease().booleanValue()) {
            this.changeActivityStatus(activity, activitySignSettings);
        }
        super.update((Object)activity);
        if (activity.getIsEnableCheckin().booleanValue()) {
            List localLists = this.activityCheckinSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)activityId));
            HashMap<String, Object> localMaps = new HashMap<String, Object>();
            for (Object checkinSetting : localLists) {
                localMaps.put(checkinSetting.getId(), checkinSetting);
            }
            CheckinSetting activityCheckinSetting = activity.getActivityCheckinSetting();
            if (activityCheckinSetting != null) {
                for (CheckinSetting checkinSetting : checkinSettingList) {
                    id = checkinSetting.getId();
                    WechatQrcode wechatQrcode = qrcodeMap.get(id);
                    if (wechatQrcode != null) {
                        this.activityCheckinSettingService.insert((Object)checkinSetting);
                        this.wechatQrcodeService.insert((Object)wechatQrcode);
                        continue;
                    }
                    this.activityCheckinSettingService.updateSelective((Object)checkinSetting);
                    localMaps.remove(id);
                }
            }
            for (Object id2 : localMaps.keySet()) {
                this.activityCheckinSettingService.deleteById(id2);
            }
        }
        List<SignDataSetting> signDataList = activity.getSignDataSettingList();
        List localList = this.signDataSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)activityId));
        HashMap<String, SignDataSetting> localMap = new HashMap<String, SignDataSetting>();
        for (SignDataSetting signDataSetting : localList) {
            localMap.put(signDataSetting.getId(), signDataSetting);
        }
        for (SignDataSetting signDataSetting : signDataList) {
            id = signDataSetting.getId();
            if (StringUtils.isBlank((CharSequence)id)) {
                signDataSetting.setId(GuidGenerator.generate());
                signDataSetting.setSourceId(activityId);
                signDataSetting.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
                this.signDataSettingService.insert((Object)signDataSetting);
                continue;
            }
            if (!localMap.containsKey(id)) continue;
            this.signDataSettingService.updateSelective((Object)signDataSetting);
            localMap.remove(id);
        }
        for (Object id2 : localMap.keySet()) {
            this.signDataSettingService.updateDelete(id2);
        }
        List<ActivityTag> activityTagList = activity.getActivityTagList();
        this.activityTagService.delete(JpaCriteria.builder().eq("activityId", (Object)activityId));
        for (ActivityTag activityTag : activityTagList) {
            activityTag.setId(GuidGenerator.generate());
            activityTag.setActivityId(activityId);
        }
        this.activityTagService.insertBatch(activityTagList);
        ActivityFee activityFee = activity.getActivityFee();
        Integer point = activityFee.getPoint();
        if (point == null) {
            activityFee.setPoint(0);
        } else {
            String comboPayPolicy = activityFee.getComboPayPolicy();
            if (StringUtil.isBlank((String)comboPayPolicy)) {
                activityFee.setComboPayPolicy(ActivityComboPayPolicyEnum.ALL.value());
            }
        }
        Integer distributerCommission = activityFee.getDistributerCommission();
        if (distributerCommission == null) {
            activityFee.setDistributerCommission(0);
        }
        if ((distributerCommissionNeedAudit = activityFee.getDistributerCommissionNeedAudit()) == null) {
            activityFee.setDistributerCommissionNeedAudit(false);
        }
        if ((sharePoint = activityFee.getSharerPoint()) == null) {
            activityFee.setSharerPoint(0);
        }
        if ((sharerCommission = activityFee.getSharerCommission()) == null) {
            activityFee.setSharerCommission(0);
        }
        if ((sharerCommissionNeedAudit = activityFee.getSharerCommissionNeedAudit()) == null) {
            activityFee.setSharerCommissionNeedAudit(false);
        }
        this.activityFeeService.updateSelective((Object)activityFee);
        ActivityPointSetting activityScore = activity.getActivityPointSetting();
        if (activityScore != null) {
            if (StringUtil.isBlank((String)activityScore.getId())) {
                this.activityPointSettingService.insertByActivity(activityScore, activityId);
            } else {
                this.activityPointSettingService.updateByActivity(activityScore);
            }
        }
        if ((calendarEvent = this.calendarEventService.selectBySourceId(activity.getId())) != null) {
            calendarEvent.setTitle(activity.getTitle());
            calendarEvent.setInfo(activity.getInfo());
            calendarEvent.setPlace(activity.getPlace());
            calendarEvent.setAddress(activity.getAddress());
            calendarEvent.setStartTime(activity.getStartTime());
            calendarEvent.setEndTime(activity.getEndTime());
            calendarEvent.setRemaindTitle(activitySignSettings.getRemaindTitle());
            calendarEvent.setRemaindInfo(activitySignSettings.getRemaindInfo());
            this.calendarEventService.updateSelective((Object)calendarEvent);
            List list = this.memberCalendarEventService.selectList(JpaCriteria.builder().eq("calendarEventId", (Object)calendarEvent.getId()));
            for (MemberCalendarEvent memberCalendarEvent : list) {
                memberCalendarEvent.setRemaindTime(activitySignSettings.getRemaindTime());
                memberCalendarEvent.setIsEnableSmsRemind(activitySignSettings.getIsEnableSmsRemind());
                memberCalendarEvent.setIsEnableWxRemind(activitySignSettings.getIsEnableWxRemind());
                memberCalendarEvent.setIsEnableWxTemplateRemind(activitySignSettings.getIsEnableWxTemplateRemind());
                this.memberCalendarEventService.updateSelective((Object)memberCalendarEvent);
            }
        }
        return activityId;
    }

    public Activity get(String id) {
        Activity activity = (Activity)((Object)super.selectById((Object)id));
        Content content = (Content)this.contentService.selectById((Object)activity.getContentId());
        if (content != null) {
            activity.setContent(content.getContent());
        }
        List signDataList = this.signDataSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)id).orderBy("sort"));
        activity.setSignDataSettingList(signDataList);
        List<ActivityTag> activityTagList = this.activityTagMapper.selectTagList(id);
        activity.setActivityTagList(activityTagList);
        ActivityFee activityFees = (ActivityFee)((Object)this.activityFeeService.select(JpaCriteria.builder().eq("activityId", (Object)id)));
        activity.setActivityFee(activityFees);
        List activityCheckinSettingLists = this.activityCheckinSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)id));
        if (activityCheckinSettingLists != null && activityCheckinSettingLists.size() > 0) {
            CheckinSetting activityCheckinSetting = new CheckinSetting();
            BeanUtils.copyProperties(activityCheckinSettingLists.get(0), (Object)activityCheckinSetting);
            ArrayList<CheckinTime> checkinTimeList = new ArrayList<CheckinTime>();
            for (CheckinSetting checkinSetting : activityCheckinSettingLists) {
                CheckinTime checkinTime = new CheckinTime();
                checkinTime.setCheckinSettingId(checkinSetting.getId());
                checkinTime.setCheckinStartTime(checkinSetting.getCheckinStartTime());
                checkinTime.setCheckinLateTime(checkinSetting.getCheckinLateTime());
                checkinTime.setCheckinEndTime(checkinSetting.getCheckinEndTime());
                checkinTime.setCheckinQrcodeUrl(checkinSetting.getCheckinQrcodeUrl());
                checkinTimeList.add(checkinTime);
            }
            activityCheckinSetting.setCheckinTimeList(checkinTimeList);
            activity.setActivityCheckinSetting(activityCheckinSetting);
        }
        ActivitySignSetting activitySignSettings = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)id)));
        activity.setActivitySignSetting(activitySignSettings);
        ActivityPointSetting pointSetting = this.activityPointSettingService.selectByActivityId(id);
        activity.setActivityPointSetting(pointSetting);
        return activity;
    }

    public Activity getMobile(String id) {
        ActivitySignSetting activitySignSetting;
        Activity activity = this.activityMapper.selectActivityById(id, this.getAppId());
        Shift.throwsIfInvalid((activity == null || activity.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        activity.setActivitStatus(ActivityStatusEnum.getNameByIndex(activity.getStatus()));
        Content content = (Content)this.contentService.selectById((Object)activity.getContentId());
        if (content != null) {
            activity.setContent(content.getContent());
        }
        List<ActivityTag> activityTagList = this.activityTagMapper.selectTagList(id);
        activity.setActivityTagList(activityTagList);
        List signDataList = this.signDataSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)id).eq("isSignShow", (Object)true).eq("appId", (Object)activity.getAppId()).orderBy("sort"));
        activity.setSignDataSettingList(signDataList);
        if (activity.getIsEnableFee().booleanValue()) {
            ActivityFee activityFee = (ActivityFee)((Object)this.activityFeeService.select(JpaCriteria.builder().eq("activityId", (Object)id).eq("appId", (Object)activity.getAppId())));
            activity.setActivityFee(activityFee);
        }
        if (null != (activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)id).eq("appId", (Object)activity.getAppId()))))) {
            ArrayList<String> showSignStatus = new ArrayList<String>();
            if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableToAuditShow())) {
                showSignStatus.add(SignStatusEnum.NOT_AUDIT.getIndex().toString());
            }
            if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableUnpaidShow())) {
                showSignStatus.add(SignStatusEnum.NOT_PAY.getIndex().toString());
            }
            if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableSignShow())) {
                showSignStatus.add(SignStatusEnum.SIGN.getIndex().toString());
            }
            if (showSignStatus.size() == 0) {
                showSignStatus.add("0");
            }
            List<Sign> list = this.activitySignMapper.getMemberSigns(id, showSignStatus);
            activitySignSetting.setSignNum(list.size());
            List<String> imageList = this.activitySignMapper.getMemberImage(id, showSignStatus);
            activitySignSetting.setImageList(imageList);
            activity.setActivitySignSetting(activitySignSetting);
            int count = this.activitySignMapper.selectCount(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("sourceId", (Object)id).eq("status", (Object)SignStatusEnum.SIGN.getIndex()));
            activity.setRealSignNum(count);
            if (StringUtil.isBlank((String)activitySignSetting.getSignTips())) {
                activitySignSetting.setSignTips(this.signService.getSignTips().getValue());
            }
        }
        return activity;
    }

    public Integer getSettingSignNum(String activityId) {
        ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)activityId).eq("appId", (Object)this.getAppId())));
        if (activitySignSetting == null) {
            return null;
        }
        ArrayList<String> showSignStatus = new ArrayList<String>();
        if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableToAuditShow())) {
            showSignStatus.add(SignStatusEnum.NOT_AUDIT.getIndex().toString());
        }
        if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableUnpaidShow())) {
            showSignStatus.add(SignStatusEnum.NOT_PAY.getIndex().toString());
        }
        if (BooleanUtils.isTrue((Boolean)activitySignSetting.getIsEnableSignShow())) {
            showSignStatus.add(SignStatusEnum.SIGN.getIndex().toString());
        }
        if (showSignStatus.size() == 0) {
            showSignStatus.add("0");
        }
        List<Sign> list = this.activitySignMapper.getMemberSigns(activityId, showSignStatus);
        return list.size();
    }

    public List<Activity> getList(Page page) {
        return this.activityMapper.getList(page);
    }

    public List<Activity> signActivityPage(Page page) {
        return this.activityMapper.signActivityPage(page);
    }

    public List<DistributerActivityWebPageResponse> selectDistributerActivityPage(String title, String orderBy, String appId, Page page) {
        if (StringUtil.isNotBlank((String)title)) {
            page.put((Object)"title", (Object)("%" + title + "%"));
        }
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"orderBy", (Object)orderBy);
        return this.activityMapper.selectDistributerActivityPage(page);
    }

    public List<DistributerActivityWebPageResponse> selectSharerActivityPage(String title, String orderBy, String appId, Page page) {
        if (StringUtil.isNotBlank((String)title)) {
            page.put((Object)"title", (Object)("%" + title + "%"));
        }
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"orderBy", (Object)orderBy);
        return this.activityMapper.selectSharerActivityPage(page);
    }

    public void changeActivityStatus(Activity activity, ActivitySignSetting activitySignSetting) {
        if (activity.getIsRelease().booleanValue()) {
            Date now = new Date();
            if (now.after(activity.getEndTime())) {
                activity.setStatus(ActivityStatusEnum.END.getIndex());
            } else if (now.after(activity.getStartTime())) {
                activity.setStatus(ActivityStatusEnum.ING.getIndex());
            } else if (now.after(activitySignSetting.getSignEndTime())) {
                activity.setStatus(ActivityStatusEnum.SIGN_END.getIndex());
            } else if (now.after(activitySignSetting.getSignStartTime())) {
                activity.setStatus(ActivityStatusEnum.SIGN_ING.getIndex());
            } else if (now.before(activitySignSetting.getSignStartTime())) {
                activity.setStatus(ActivityStatusEnum.NOT_START.getIndex());
            }
        }
    }

    public void updateActivityStatus() {
        List activityList = this.activityMapper.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false).eq("isRelease", (Object)true).ne("status", (Object)ActivityStatusEnum.END.getIndex()));
        for (Activity activity : activityList) {
            int status = activity.getStatus();
            ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingMapper.select(JpaCriteria.builder().eq("activityId", (Object)activity.getId())));
            this.changeActivityStatus(activity, activitySignSetting);
            if (status == activity.getStatus()) continue;
            super.updateSelective((Object)activity);
        }
    }

    public void updateRelease(String id, Boolean isRelease) {
        Activity activity = (Activity)((Object)super.selectById((Object)id));
        activity.setIsRelease(isRelease);
        if (isRelease.booleanValue()) {
            ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingMapper.select(JpaCriteria.builder().eq("activityId", (Object)activity.getId())));
            this.changeActivityStatus(activity, activitySignSetting);
        }
        super.updateSelective((Object)activity);
    }

    public void validCheckinTime(CheckinTime checkinTime) {
        Shift.throwsIfNull((Object)checkinTime.getCheckinStartTime(), (String)"\u5f00\u59cb\u7b7e\u5230\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfNull((Object)checkinTime.getCheckinEndTime(), (String)"\u7ed3\u675f\u7b7e\u5230\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfNull((Object)checkinTime.getCheckinLateTime(), (String)"\u7b7e\u5230\u8fdf\u5230\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfInvalid((boolean)checkinTime.getCheckinStartTime().after(checkinTime.getCheckinEndTime()), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        Shift.throwsIfInvalid((boolean)checkinTime.getCheckinStartTime().after(checkinTime.getCheckinLateTime()), (String)"\u8fdf\u5230\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        Shift.throwsIfInvalid((boolean)checkinTime.getCheckinLateTime().after(checkinTime.getCheckinEndTime()), (String)"\u8fdf\u5230\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
    }

    @Transactional
    public void deleteActivity(String id) {
        super.updateDelete((Object)id);
        CalendarEvent calendarEvent = (CalendarEvent)this.calendarEventService.select(JpaCriteria.builder().eq("sourceId", (Object)id));
        if (calendarEvent != null) {
            this.calendarEventService.deleteById((Object)calendarEvent.getId());
            this.memberCalendarEventService.delete(JpaCriteria.builder().eq("calendarEventId", (Object)calendarEvent.getId()));
        }
    }

    public int getActivitySort() {
        int count = this.activityMapper.selectCount(JpaCriteria.builder().eq("appId", (Object)this.getAppId()));
        return (count + 1) * 10;
    }

    public List<Activity> selectPages(Page page) {
        return this.activityMapper.selectPages(page);
    }

    public List<Activity> listByMemberId(String memberId) {
        List<Activity> ats = this.activityMapper.listByMemberId(memberId);
        for (Activity activity : ats) {
            List<ActivityTag> activityTagList = this.activityTagMapper.selectTagList(activity.getId());
            activity.setActivityTagList(activityTagList);
        }
        return ats;
    }

    public void updateIsSpecialQuestion(Boolean isSpecialQuestion, String id) {
        this.activityMapper.updateIsSpecialQuestion(isSpecialQuestion, id);
    }
}

