/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.task;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.constant.MiniProgramMessageFormat;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.AppManagerService;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.task.SendTemplateMessageToAppManagerTask;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.StringUtil;
import com.wego168.wechat.impl.WechatAccessTokenHelper;
import com.wego168.wx.component.WxMsgTemplateSender;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.model.MessgaeTemplateResponse;
import com.wego168.wx.model.WxMsgTemplateParamter;
import com.wego168.wx.persistence.WxAppMapper;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.service.WxMsgTemplateService;
import com.wego168.wx.token.WechatAccessTokenHelper2;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ActivityNotification {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private WxMsgTemplateService templateService;
    @Autowired
    private AppManagerService appManagerService;
    @Autowired
    private WxAppMapper appMapper;
    @Autowired
    private WechatAccessTokenHelper wechatAccessTokenHelper;
    @Autowired
    private SendTemplateMessageToAppManagerTask sendTemplateMessageToAppManagerTask;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private WxMsgTemplateSender wxMsgTemplateSender;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private WechatAccessTokenHelper2 wechatAccessTokenHelper2;
    private Logger logger = LoggerFactory.getLogger(ActivityNotification.class);

    public void sendActivitySignNotificationToAppManager(String activityTitle, String appId, String memberId, Date activityStartTime) {
        this.logger.error("send activity sign notification, activity->{}", (Object)activityTitle);
        List appManagerList = this.appManagerService.selectListByAppId(appId);
        if (Checker.listIsEmpty((List)appManagerList)) {
            this.logger.error("no app manager");
            return;
        }
        int serviceType = ServiceTypeEnum.SERVICE.id();
        WxApp wego168 = (WxApp)this.appMapper.select(JpaCriteria.builder().eq("appId", (Object)"0").eq("serviceType", (Object)serviceType));
        if (wego168 == null) {
            this.logger.error("wego168 app is not configured");
            return;
        }
        String type = "USER_SIGN_MANAGER_NOTIFICATION";
        MessgaeTemplateResponse response = this.templateService.selectByType2(type, serviceType, "0");
        LinkedHashMap<String, String> replacement = new LinkedHashMap<String, String>();
        Member member = this.memberService.selectById(memberId);
        replacement.put("activity", activityTitle);
        replacement.put("name", StringUtil.isBlank((String)member.getName()) ? "\u6682\u65e0" : member.getName());
        replacement.put("mobile", StringUtil.isBlank((String)member.getMobilePhoneNumber()) ? "\u6682\u65e0" : member.getMobilePhoneNumber());
        replacement.put("arriveTime", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(activityStartTime));
        replacement.put("signTime", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
        response.replace(replacement);
        String accessToken = this.wechatAccessTokenHelper.getToken(wego168.getWxAppId(), false);
        this.sendTemplateMessageToAppManagerTask.sendTemplateMessage(appManagerList, response, accessToken);
    }

    @Async
    public void sendActivityCheckinNotificationToAppManagerAsync(Sign sign) {
        String activityId = sign.getSourceId();
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        String activityTitle = activity.getTitle();
        String appId = sign.getAppId();
        String memberId = sign.getMemberId();
        this.sendActivityCheckinNotificationToAppManagerAsync(activityTitle, appId, memberId);
    }

    @Async
    public void sendActivityCheckinNotificationToAppManagerAsync(String activityTitle, String appId, String memberId) {
        this.logger.error("send activity checkin notification, activity->{}", (Object)activityTitle);
        List appManagerList = this.appManagerService.selectListByAppId(appId);
        if (Checker.listIsEmpty((List)appManagerList)) {
            this.logger.error("no app manager");
            return;
        }
        int serviceType = ServiceTypeEnum.SERVICE.id();
        WxApp wego168 = (WxApp)this.appMapper.select(JpaCriteria.builder().eq("appId", (Object)"0").eq("serviceType", (Object)serviceType));
        if (wego168 == null) {
            this.logger.error("wego168 app is not configured");
            return;
        }
        String type = "USER_CHECKIN_MANAGER_NOTIFICATION";
        MessgaeTemplateResponse messgaeTemplateResponse = this.templateService.selectByType2(type, serviceType, "0");
        LinkedHashMap<String, String> replacement = new LinkedHashMap<String, String>();
        Member member = this.memberService.selectById(memberId);
        replacement.put("activityTitle", activityTitle);
        String phone = member.getMobilePhoneNumber().substring(0, 3) + "****" + member.getMobilePhoneNumber().substring(7);
        String content = phone + "(" + member.getName() + ")";
        replacement.put("content", content);
        replacement.put("time", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
        messgaeTemplateResponse.replace(replacement);
        this.logger.error("sendActivityCheckinNotificationToAppManager\u7684\u53d1\u9001\u53c2\u6570, replacement->{}", replacement);
        String accessToken = this.wechatAccessTokenHelper2.getAccessToken(wego168);
        this.sendTemplateMessageToAppManagerTask.sendTemplateMessage(appManagerList, messgaeTemplateResponse, accessToken);
    }

    public void sendActivitySignSuccessNotification(Activity activity, String memberId, Integer status) {
        int serviceType = ServiceTypeEnum.PROGRAM.id();
        WxApp miniProgram = this.wxAppService.selectByAppId(activity.getAppId(), serviceType);
        if (miniProgram == null) {
            this.logger.error("mini program is not configured");
            return;
        }
        MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        if (memberAccount == null) {
            this.logger.error("no miniprogram account");
            return;
        }
        String openId = memberAccount.getUsername();
        Member member = this.memberService.selectById(memberId);
        String accessToken = this.wechatAccessTokenHelper.getToken(miniProgram.getWxAppId(), false);
        Integer entryType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
        String url = "pagesCoWebs/activity/detail/index?id=" + activity.getId();
        WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)activity.getAppId(), (String)"baomingjieguotongzhi", Collections.singletonList(openId), (String)url);
        this.logger.error("\u5f00\u59cb\u53d1\u9001\u5c0f\u7a0b\u5e8f\u6a21\u677f\u901a\u77e5\uff0c\u4fe1\u606f\u53c2\u6570\u662f=>{}", (Object)paramter);
        paramter.setAccessToken(accessToken);
        paramter.setServiceType(entryType);
        paramter.put((Object)"name2", (Object)MiniProgramMessageFormat.messageNameDetect(member.getName()));
        if (IntegerUtil.equals((Integer)status, (Integer)SignStatusEnum.AUDIT_NOT_PASS.getIndex())) {
            paramter.put((Object)"phrase3", (Object)"\u5ba1\u6838\u4e0d\u901a\u8fc7");
        } else {
            paramter.put((Object)"phrase3", (Object)"\u62a5\u540d\u6210\u529f");
        }
        paramter.put((Object)"thing1", (Object)MiniProgramMessageFormat.messageTingDetect(activity.getTitle()));
        paramter.put((Object)"thing6", (Object)MiniProgramMessageFormat.messageTingDetect(activity.getAddress()));
        paramter.put((Object)"time4", (Object)MiniProgramMessageFormat.messageTimeDetect(activity.getStartTime()));
        this.wxMsgTemplateSender.sendSubscribeMsg(paramter);
    }
}

