/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis;

import com.simple.mybatis.boundsql.BoundParameter;
import com.simple.mybatis.boundsql.BoundSqlStatement;
import com.simple.mybatis.boundsql.BoundSqlWrapper;
import com.simple.mybatis.boundsql.DeleteBoundSqlStatement;
import com.simple.mybatis.boundsql.InsertBoundSqlStatement;
import com.simple.mybatis.boundsql.SelectBoundSqlStatement;
import com.simple.mybatis.boundsql.UpdateBoundSqlStatement;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class BoundSqlInterceptor
extends BoundSqlWrapper
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            Method[] methods;
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            MetaObject metaStatementHandler = this.getMetaObject(statementHandler);
            MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            Configuration configuration = (Configuration)metaStatementHandler.getValue("delegate.configuration");
            Object paramObj = boundSql.getParameterObject();
            Connection connection = (Connection)invocation.getArgs()[0];
            String sqlId = mappedStatement.getId();
            String mapperClassName = this.extractClassName(sqlId);
            if (!MAPPER_METHOD_MAP.containsKey(mapperClassName)) {
                Class<?> mapperClass = Class.forName(mapperClassName);
                MAPPER_METHOD_MAP.put(mapperClassName, mapperClass.getMethods());
                MAPPER_ENTITY_MAP.put(mapperClassName, this.getEntityClass(mapperClassName, mapperClass));
            }
            String sql = null;
            boolean updatedParam = true;
            Method[] methodArray = methods = (Method[])MAPPER_METHOD_MAP.get(mapperClassName);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(this.extractMethedName(sqlId))) {
                    BoundParameter boundParameter = new BoundParameter();
                    boundParameter.setMappedStatement(mappedStatement);
                    boundParameter.setConfiguration(configuration);
                    boundParameter.setConnection(connection);
                    boundParameter.setParamObj(paramObj);
                    boundParameter.setMethod(method);
                    boundParameter.setBoundSql(boundSql);
                    boundParameter.setEntityClass((Class)MAPPER_ENTITY_MAP.get(mapperClassName));
                    if (method.isAnnotationPresent(Insert.class)) {
                        sql = InsertBoundSqlStatement.builder().execute(boundParameter);
                        break;
                    }
                    if (method.isAnnotationPresent(Update.class)) {
                        sql = UpdateBoundSqlStatement.builder().execute(boundParameter);
                        break;
                    }
                    if (method.isAnnotationPresent(Delete.class)) {
                        sql = DeleteBoundSqlStatement.builder().execute(boundParameter);
                        break;
                    }
                    if (method.isAnnotationPresent(Select.class)) {
                        sql = SelectBoundSqlStatement.builder().execute(boundParameter);
                        break;
                    }
                    sql = BoundSqlStatement.builder().execute(boundParameter);
                    updatedParam = false;
                    break;
                }
                ++n2;
            }
            if (sql != null) {
                SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
                SqlSource sqlSource = builder.parse(sql, paramObj.getClass(), null);
                metaStatementHandler.setValue("delegate.boundSql.sql", (Object)sqlSource.getBoundSql(paramObj).getSql());
                if (updatedParam) {
                    List parameterMappings = sqlSource.getBoundSql(paramObj).getParameterMappings();
                    metaStatementHandler.setValue("delegate.boundSql.parameterMappings", (Object)parameterMappings);
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

