/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaRestriction;
import com.simple.mybatis.sql.Statement;
import com.simple.mybatis.sql.WhereClause;
import com.simple.mybatis.util.ReflectionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JpaCriteria
extends Bootmap {
    private static final long serialVersionUID = -415143959347521711L;
    private static final String START = "start";
    private static final String END = "end";
    private List<WhereClause> whereClauses = new LinkedList<WhereClause>();
    private Class<?> entityClass;
    private Class<?> joinEntityClass;
    private Class<?> resultType;
    private String joinClause;
    private String fetchClause;
    private String selectClause;
    private String orderByClause;
    private String groupByClause;

    public static JpaCriteria builder(Object bean) {
        Map<String, Object> beanMap;
        JpaCriteria criteria = JpaCriteria.builder();
        if (bean instanceof Map) {
            beanMap = (Map<String, Object>)bean;
        } else {
            criteria.setEntityClass(bean.getClass());
            beanMap = ReflectionUtil.toMap(bean);
        }
        for (Object key : beanMap.keySet()) {
            criteria.put(String.valueOf(key), beanMap.get(key));
        }
        return criteria;
    }

    public static JpaCriteria builder() {
        return new JpaCriteria();
    }

    public static JpaCriteria builder(Class<?> entityClass) {
        JpaCriteria jpaCriteria = new JpaCriteria();
        jpaCriteria.setEntityClass(entityClass);
        return jpaCriteria;
    }

    public JpaCriteria select(String selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public JpaCriteria set(String field, Object value) {
        this.put(field, value);
        return this;
    }

    public JpaCriteria ne(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.ne(property, value));
    }

    public JpaCriteria ne(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.ne(property, value);
        }
        return this;
    }

    public JpaCriteria eq(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.eq(property, value));
    }

    public JpaCriteria eq(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.eq(property, value);
        }
        return this;
    }

    public JpaCriteria like(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.like(property, value));
    }

    public JpaCriteria like(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.like(property, value);
        }
        return this;
    }

    public JpaCriteria leftLike(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.leftLike(property, value));
    }

    public JpaCriteria leftLike(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.leftLike(property, value);
        }
        return this;
    }

    public JpaCriteria rightLike(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.rightLike(property, value));
    }

    public JpaCriteria rightLike(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.rightLike(property, value);
        }
        return this;
    }

    public JpaCriteria gt(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.gt(property, value));
    }

    public JpaCriteria gt(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.gt(property, value);
        }
        return this;
    }

    public JpaCriteria ge(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.ge(property, value));
    }

    public JpaCriteria ge(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.ge(property, value);
        }
        return this;
    }

    public JpaCriteria lt(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.lt(property, value));
    }

    public JpaCriteria lt(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.lt(property, value);
        }
        return this;
    }

    public JpaCriteria le(String property, Object value) {
        return this.bindCriteriaByExpression(JpaRestriction.le(property, value));
    }

    public JpaCriteria le(String property) {
        Object value = this.get(property);
        if (value != null) {
            this.le(property, value);
        }
        return this;
    }

    public JpaCriteria isNull(String property) {
        return this.bindCriteriaByExpression(JpaRestriction.isNull(property));
    }

    public JpaCriteria isNotNull(String property) {
        return this.bindCriteriaByExpression(JpaRestriction.isNotNull(property));
    }

    public JpaCriteria in(String property, Object[] value) {
        return this.bindCriteriaByExpression(JpaRestriction.in(property, value));
    }

    public JpaCriteria notIn(String property, Object[] value) {
        return this.bindCriteriaByExpression(JpaRestriction.notIn(property, value));
    }

    public JpaCriteria between(String property, Object min, Object max) {
        return this.bindCriteriaByExpression(JpaRestriction.between(property, min, max));
    }

    public JpaCriteria between(String property) {
        String propertyUpperCase = this.convertFirstPlaceToUpperCase(property);
        Object min = this.get(START + propertyUpperCase);
        Object max = this.get(END + propertyUpperCase);
        if (min != null && max != null) {
            this.between(property, min, max);
        } else if (min != null) {
            this.ge(property, min);
        } else if (max != null) {
            this.le(property, max);
        }
        return this;
    }

    private String convertFirstPlaceToUpperCase(String property) {
        String propertyUpperCase = String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1);
        return propertyUpperCase;
    }

    public JpaCriteria or(WhereClause ... clauses) {
        WhereClause whereClause = new WhereClause();
        whereClause.setOperate("or");
        whereClause.setSubWhereClauses(new LinkedList<WhereClause>());
        WhereClause[] whereClauseArray = clauses;
        int n = clauses.length;
        int n2 = 0;
        while (n2 < n) {
            WhereClause subWhereClause = whereClauseArray[n2];
            this.bindCriteriaByExpression(whereClause.getSubWhereClauses(), subWhereClause);
            ++n2;
        }
        this.whereClauses.add(whereClause);
        return this;
    }

    private JpaCriteria bindCriteriaByExpression(WhereClause whereClause) {
        return this.bindCriteriaByExpression(this.whereClauses, whereClause);
    }

    private JpaCriteria bindCriteriaByExpression(List<WhereClause> expressionList, WhereClause whereClause) {
        expressionList.add(whereClause);
        String property = whereClause.getProperty();
        if ("between".equals(whereClause.getCompare())) {
            String minPlaceholder = this.getPlaceholder("min" + property);
            String maxPlaceholder = this.getPlaceholder("max" + property);
            whereClause.setMinPlaceholder(minPlaceholder);
            whereClause.setMaxPlaceholder(maxPlaceholder);
            this.put(Statement.sign(minPlaceholder), whereClause.getMin());
            this.put(Statement.sign(maxPlaceholder), whereClause.getMax());
            return this;
        }
        String placeholder = this.getPlaceholder(property);
        whereClause.setPlaceholder(placeholder);
        this.put(Statement.sign(placeholder), whereClause.getValue());
        return this;
    }

    public JpaCriteria leftJoin(Class<?> joinClazz) {
        return this.join("left join", joinClazz);
    }

    public JpaCriteria rightJoin(Class<?> joinClazz) {
        return this.join("right join", joinClazz);
    }

    public JpaCriteria innerJoin(Class<?> joinClazz) {
        return this.join("inner join", joinClazz);
    }

    public JpaCriteria join(String joinClause, Class<?> joinEntityClass) {
        this.setJoinClause(joinClause);
        this.setJoinEntityClass(joinEntityClass);
        return this;
    }

    public List<WhereClause> getWhereClauses() {
        return this.whereClauses;
    }

    public void setWhereClauses(List<WhereClause> whereClauses) {
        this.whereClauses = whereClauses;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public JpaCriteria orderBy(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public String getGroupByClause() {
        return this.groupByClause;
    }

    public JpaCriteria groupBy(String groupByClause) {
        this.groupByClause = groupByClause;
        return this;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public JpaCriteria fetch(String fetchClause) {
        this.fetchClause = fetchClause;
        return this;
    }

    public String getFetchClause() {
        return this.fetchClause;
    }

    public String getJoinClause() {
        return this.joinClause;
    }

    public void setJoinClause(String joinClause) {
        this.joinClause = joinClause;
    }

    public Class<?> getJoinEntityClass() {
        return this.joinEntityClass;
    }

    public void setJoinEntityClass(Class<?> joinEntityClass) {
        this.joinEntityClass = joinEntityClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    private String getPlaceholder(String property) {
        if (this.containsKey(Statement.sign(property))) {
            return this.getPlaceholder(1, property);
        }
        return property;
    }

    private String getPlaceholder(int index, String property) {
        String key = String.valueOf(property) + index;
        if (this.containsKey(Statement.sign(key))) {
            this.getPlaceholder(++index, property);
        }
        return key;
    }
}

