/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis;

import com.simple.mybatis.annotation.Table;
import com.simple.mybatis.sql.MyBatisSqlProcessor;
import com.simple.mybatis.sql.MySQLDialect;
import com.simple.mybatis.sql.SqlParser;
import com.simple.mybatis.util.ClassHandler;
import com.simple.mybatis.util.ClassScanner;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class MybatisJpaDriver
implements InitializingBean {
    private List<String> scanPackages;

    public void afterPropertiesSet() throws Exception {
        if (this.scanPackages != null) {
            new ClassScanner(new ClassHandler(){

                @Override
                public void handle(Class<?> clazz) {
                    if (clazz.isAnnotationPresent(Table.class)) {
                        SqlParser sqlParser = SqlParser.getInstance();
                        sqlParser.setSqlProcessor(new MyBatisSqlProcessor(MySQLDialect.of()));
                        sqlParser.parse(clazz);
                    }
                }
            }, new FileFilter(){

                @Override
                public boolean accept(File path) {
                    if (path.isDirectory()) {
                        return true;
                    }
                    return path.isFile() && path.getName().endsWith(".class");
                }
            }).scanClass(true, this.scanPackages);
        }
    }

    public void setScanPackages(List<String> scanPackages) {
        this.scanPackages = scanPackages;
    }
}

