/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.boundsql.BoundSqlWrapper;
import com.simple.mybatis.sql.SqlParser;
import com.simple.mybatis.util.FieldNameUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class ResultSetInterceptor
extends BoundSqlWrapper
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameObject = args[1];
        if (parameObject != null && parameObject instanceof JpaCriteria) {
            MetaObject mappedStatementHandler = this.getMetaObject(mappedStatement);
            JpaCriteria jpaCriteria = (JpaCriteria)parameObject;
            if (jpaCriteria.getResultType() != null) {
                mappedStatementHandler.setValue("resultMaps[0].type", jpaCriteria.getResultType());
            }
        }
        Object result = invocation.proceed();
        boolean columnSnakeCase = SqlParser.getInstance().getSqlConfig().isColumnSnakeCase();
        if (columnSnakeCase) {
            if (result instanceof ArrayList) {
                Object object;
                ArrayList resultList = (ArrayList)result;
                if (resultList.size() > 0 && (object = resultList.get(0)) instanceof Map) {
                    boolean isBoot = object instanceof Bootmap;
                    Map rowMap = (Map)resultList.get(0);
                    boolean isCamelCase = false;
                    for (String property : rowMap.keySet()) {
                        if (property.indexOf("_") <= -1) continue;
                        isCamelCase = true;
                        break;
                    }
                    if (isCamelCase) {
                        LinkedList<Map<String, Object>> lists;
                        if (isBoot) {
                            lists = new LinkedList<Map<String, Object>>();
                            int i = 0;
                            while (i < resultList.size()) {
                                Bootmap resultMap = (Bootmap)resultList.get(i);
                                lists.add(this.wrapRowToBootmap(resultMap));
                                ++i;
                            }
                            return lists;
                        }
                        lists = new LinkedList();
                        int i = 0;
                        while (i < resultList.size()) {
                            Map resultMap = (Map)resultList.get(i);
                            lists.add(this.wrapRowToMap(resultMap));
                            ++i;
                        }
                        return lists;
                    }
                }
            } else if (result instanceof Map) {
                boolean isBoot = result instanceof Bootmap;
                if (isBoot) {
                    Bootmap resultMap = (Bootmap)result;
                    return this.wrapRowToBootmap(resultMap);
                }
                Map resultMap = (Map)result;
                return this.wrapRowToMap(resultMap);
            }
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Bootmap wrapRowToBootmap(Map<String, Object> resultMap) {
        Bootmap bootmap = new Bootmap();
        this.wrapRow(bootmap, resultMap);
        return bootmap;
    }

    private Map<String, Object> wrapRowToMap(Map<String, Object> resultMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.wrapRow(map, resultMap);
        return map;
    }

    private void wrapRow(Map<String, Object> map, Map<String, Object> resultMap) {
        for (String property : resultMap.keySet()) {
            if (property.indexOf("_") > -1) {
                map.put(FieldNameUtils.camelCase(property), resultMap.get(property));
                continue;
            }
            map.put(property, resultMap.get(property));
        }
    }
}

