/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.boundsql;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.MyBatisJpaMapper;
import com.simple.mybatis.boundsql.BoundParameter;
import com.simple.mybatis.sql.SqlParser;
import com.simple.mybatis.util.StrUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

public class BoundSqlWrapper {
    protected static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    protected static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    protected static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    protected static final SqlParser SQL_PARSER = SqlParser.getInstance();
    protected static final Map<String, Method[]> MAPPER_METHOD_MAP = new ConcurrentHashMap<String, Method[]>();
    protected static final Map<String, Class<?>> MAPPER_ENTITY_MAP = new ConcurrentHashMap();

    public MetaObject getMetaObject(Object object) {
        MetaObject metaObject = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        return metaObject;
    }

    protected String extractClassName(String sqlId) {
        return StrUtils.isBlank(sqlId) ? null : sqlId.substring(0, sqlId.lastIndexOf("."));
    }

    protected String extractMethedName(String sqlId) {
        return StrUtils.isBlank(sqlId) ? null : sqlId.substring(sqlId.lastIndexOf(".") + 1, sqlId.length());
    }

    protected Class<?> handleEntityClass(BoundParameter boundParameter) {
        JpaCriteria jpaCriteria;
        Object paramObj = boundParameter.getParamObj();
        if (paramObj instanceof Map && paramObj instanceof JpaCriteria && (jpaCriteria = (JpaCriteria)paramObj).getEntityClass() != null) {
            boundParameter.setEntityClass(jpaCriteria.getEntityClass());
        }
        return boundParameter.getEntityClass();
    }

    protected Class<?> getEntityClass(String mapperClassName, Class<?> mapperClass) {
        if (!MAPPER_ENTITY_MAP.containsKey(mapperClass)) {
            Type[] genericTypes;
            Type genericType = null;
            Type[] interfacesTypes = mapperClass.getGenericInterfaces();
            if (interfacesTypes != null && interfacesTypes.length > 0 && (genericTypes = ((ParameterizedType)interfacesTypes[0]).getActualTypeArguments()) != null && genericTypes.length > 0) {
                genericType = genericTypes[0];
            }
            if (genericType == null && mapperClass.isAnnotationPresent(MyBatisJpaMapper.class)) {
                MyBatisJpaMapper jpaMapper = mapperClass.getAnnotation(MyBatisJpaMapper.class);
                genericType = jpaMapper.value();
            }
            if (genericType != null) {
                MAPPER_ENTITY_MAP.put(mapperClassName, (Class<?>)genericType);
            }
        }
        return MAPPER_ENTITY_MAP.get(mapperClassName);
    }

    protected long count(BoundParameter boundParameter, String sql) throws SQLException {
        String tsql = sql.toLowerCase().trim().replaceAll("\n", " ").replaceAll("\t", " ");
        if (tsql.endsWith(" desc") || tsql.endsWith(" asc")) {
            sql = sql.substring(0, tsql.lastIndexOf(" order ") + 1);
        }
        String countSql = "select count(*) count " + sql.substring(tsql.indexOf(" from ") + 1, sql.length());
        MappedStatement mappedStatement = boundParameter.getMappedStatement();
        Object paramObj = boundParameter.getParamObj();
        BoundSql countBoundSql = boundParameter.getBoundSql();
        Connection connection = boundParameter.getConnection();
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, paramObj, countBoundSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(countSql);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
        return 0L;
    }
}

