/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.boundsql;

import com.simple.mybatis.boundsql.BoundParameter;
import com.simple.mybatis.boundsql.BoundSqlWrapper;
import com.simple.mybatis.boundsql.MapperPattern;
import com.simple.mybatis.exception.BoundSqlException;
import com.simple.mybatis.sql.Insert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InsertBoundSqlStatement
extends BoundSqlWrapper {
    private static final InsertBoundSqlStatement INSTANCE = new InsertBoundSqlStatement();
    private static final String LIST_KEY = "list";

    public static InsertBoundSqlStatement builder() {
        return INSTANCE;
    }

    public String execute(BoundParameter boundParameter) {
        org.apache.ibatis.annotations.Insert selectAnno = boundParameter.getMethod().getAnnotation(org.apache.ibatis.annotations.Insert.class);
        String annoVal = selectAnno.value()[0];
        if (!MapperPattern.MAPPER_SET.contains(annoVal)) {
            return null;
        }
        Object paramObj = boundParameter.getParamObj();
        Insert insert = null;
        if ("DEFAULT".equals(annoVal)) {
            boundParameter.setEntityClass(paramObj.getClass());
            insert = new Insert(boundParameter.getEntityClass());
            insert.setBatch(false);
        } else if ("BATCH".equals(annoVal) && paramObj instanceof HashMap) {
            Map param = (Map)paramObj;
            if (param.size() != 2) {
                throw new BoundSqlException("Parameter error of batch insertion, only one list set is allowed");
            }
            List list = (List)param.get(LIST_KEY);
            if (list == null || list.size() == 0) {
                throw new BoundSqlException("Collection cannot be empty and it's size must be greater than 0");
            }
            boundParameter.setEntityClass(list.get(0).getClass());
            insert = new Insert(boundParameter.getEntityClass());
            insert.setBatch(true);
            insert.setListKey(LIST_KEY);
            insert.setListSize(list.size());
        }
        return insert.toStatementString();
    }
}

