/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.boundsql;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.simple.mybatis.boundsql.BoundParameter;
import com.simple.mybatis.boundsql.BoundSqlWrapper;
import com.simple.mybatis.boundsql.MapperPattern;
import com.simple.mybatis.exception.BoundSqlException;
import com.simple.mybatis.sql.Select;
import com.simple.mybatis.util.StrUtils;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class SelectBoundSqlStatement
extends BoundSqlWrapper {
    private static final SelectBoundSqlStatement INSTANCE = new SelectBoundSqlStatement();

    public static SelectBoundSqlStatement builder() {
        return INSTANCE;
    }

    public String execute(BoundParameter boundParameter) {
        org.apache.ibatis.annotations.Select selectAnno = boundParameter.getMethod().getAnnotation(org.apache.ibatis.annotations.Select.class);
        String annoVal = selectAnno.value()[0];
        if (!MapperPattern.MAPPER_SET.contains(annoVal)) {
            return null;
        }
        Class<?> entityClass = this.handleEntityClass(boundParameter);
        Select select = new Select(entityClass);
        String sql = null;
        if ("ID".equals(annoVal)) {
            select.setId(true);
            sql = select.toStatementString();
        } else if ("COUNT".equals(annoVal)) {
            Object paramObj = boundParameter.getParamObj();
            select.setSelectClause(" count(1) count ");
            if (paramObj instanceof JpaCriteria) {
                JpaCriteria criteria = (JpaCriteria)paramObj;
                select.setWhereClauses(criteria.getWhereClauses());
            }
            sql = select.toStatementString();
        } else if ("DEFAULT".equals(annoVal)) {
            Object paramObj = boundParameter.getParamObj();
            if (paramObj instanceof JpaCriteria) {
                JpaCriteria criteria = (JpaCriteria)paramObj;
                select.setWhereClauses(criteria.getWhereClauses());
                select.setSelectClause(criteria.getSelectClause());
                select.setJoinClause(criteria.getJoinClause());
                select.setFetchClause(criteria.getFetchClause());
                select.setJoinEntityClass(criteria.getJoinEntityClass());
                select.setOrderByClause(criteria.getOrderByClause());
                select.setGroupByClause(criteria.getGroupByClause());
            }
            sql = select.toStatementString();
            if (paramObj instanceof Page) {
                Page page = (Page)paramObj;
                if (page.isCount()) {
                    try {
                        long total = this.getCount(boundParameter, sql);
                        page.setTotal(total);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                sql = select.getDialect().page(sql, page.getStartRow(), page.getPageSize());
            }
        }
        return sql;
    }

    private long getCount(BoundParameter boundParameter, String sql) throws SQLException {
        if (StrUtils.isBlank(sql)) {
            throw new BoundSqlException("sql can't be empty :" + sql);
        }
        Object paramObj = boundParameter.getParamObj();
        Configuration configuration = boundParameter.getConfiguration();
        MappedStatement mappedStatement = boundParameter.getMappedStatement();
        SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
        SqlSource sqlSource = builder.parse(sql, paramObj.getClass(), null);
        List parameterMappings = sqlSource.getBoundSql(paramObj).getParameterMappings();
        BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), sql, parameterMappings, paramObj);
        boundParameter.setBoundSql(countBoundSql);
        return this.count(boundParameter, sqlSource.getBoundSql(paramObj).getSql());
    }
}

