/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.SqlDialect;
import com.simple.mybatis.sql.SqlEntity;
import com.simple.mybatis.sql.SqlField;
import com.simple.mybatis.util.FieldNameUtils;
import com.simple.mybatis.util.StrUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSqlProcessor {
    private static final String INSERT = "insert into %s (%s) values (%s) ";
    private static final String INSERT_BATCH = "insert into %s (%s) values (%s) ";
    private static final String UPDATE = "update %s set %s where %s ";
    private static final String UPDATE_LOCK_VERSION = "update %s set %s where %s ";
    private static final String DELETE = "delete from %s where %s ";
    private static final String SELECT = "select %s from %s where %s ";

    public abstract String getPlaceholder(Class<?> var1, String var2);

    public abstract SqlDialect getDialect();

    public String getPlaceholder(SqlField sqlField) {
        if (sqlField == null) {
            return "";
        }
        return this.getPlaceholder(sqlField.getJdbcType(), sqlField.getField());
    }

    public void parseSql(SqlEntity sqlEntity) {
        Map<String, SqlField> sqlFieldMap = sqlEntity.getSqlFieldMap();
        LinkedList<String> columnList = new LinkedList<String>();
        LinkedList<String> propertyJdbcTypeLists = new LinkedList<String>();
        LinkedList<String> columnPropertyList = new LinkedList<String>();
        LinkedList<String> lockVersionColumnPropertyList = new LinkedList<String>();
        LinkedList<SqlField> lockVersionList = new LinkedList<SqlField>();
        if (sqlFieldMap != null && sqlFieldMap.size() > 0) {
            for (String field : sqlFieldMap.keySet()) {
                SqlField sqlField = sqlFieldMap.get(field);
                if (sqlField.isTransient()) continue;
                String column = this.getDialect().escape(sqlField.getColumn());
                columnList.add(column);
                propertyJdbcTypeLists.add(this.getPlaceholder(sqlField));
                if (sqlField.isId()) continue;
                columnPropertyList.add(String.valueOf(column) + " = " + this.getPlaceholder(sqlField));
                if (sqlField.isLockVersion()) {
                    lockVersionColumnPropertyList.add(String.valueOf(column) + " = 1 + " + column);
                    lockVersionList.add(sqlField);
                    continue;
                }
                lockVersionColumnPropertyList.add(String.valueOf(column) + " = " + this.getPlaceholder(sqlField));
            }
            if (columnList.size() > 0) {
                this.initializeInsertSql(sqlEntity, columnList, propertyJdbcTypeLists);
                this.initializeInsertBatchSql(sqlEntity, columnList, propertyJdbcTypeLists);
                this.initializeUpdateSql(sqlEntity, columnPropertyList);
                this.initializeUpdateLockVersionSql(sqlEntity, lockVersionColumnPropertyList, lockVersionList);
                this.initializeDeleteSql(sqlEntity);
                this.initializeSelectSql(sqlEntity);
            }
        }
    }

    public void initializeInsertSql(SqlEntity entity, List<String> columnList, List<String> propertyList) {
        String sql = String.format("insert into %s (%s) values (%s) ", this.getDialect().escape(entity.getTable()), StrUtils.join(columnList, " , "), StrUtils.join(propertyList, " , "));
        entity.setInsertSql(sql);
    }

    public void initializeInsertBatchSql(SqlEntity entity, List<String> columnList, List<String> propertyJdbcTypeLists) {
        LinkedList<String> lists = new LinkedList<String>();
        for (String propertyJdbcType : propertyJdbcTypeLists) {
            int right = propertyJdbcType.indexOf(",jdbcType=");
            String str = "#{%PLACE_HOLDER%." + propertyJdbcType.substring(2, right) + propertyJdbcType.substring(right, propertyJdbcType.length());
            lists.add(str);
        }
        String sql = String.format("insert into %s (%s) values (%s) ", this.getDialect().escape(entity.getTable()), StrUtils.join(columnList, " , "), StrUtils.join(lists, " , "));
        entity.setInsertBatchSql(sql);
    }

    public void initializeUpdateSql(SqlEntity entity, List<String> columnPropertyList) {
        SqlField idSqlField = entity.getIdSqlField();
        if (idSqlField == null) {
            entity.setUpdateSql(null);
        } else {
            String condition = String.valueOf(this.getDialect().escape(idSqlField.getColumn())) + " = " + this.getPlaceholder(idSqlField);
            String sql = String.format("update %s set %s where %s ", this.getDialect().escape(entity.getTable()), StrUtils.join(columnPropertyList, " , "), condition);
            entity.setUpdateSql(sql);
        }
    }

    public void initializeUpdateLockVersionSql(SqlEntity entity, List<String> lockVersionColumnPropertyList, List<SqlField> lockVersionList) {
        SqlField idSqlField = entity.getIdSqlField();
        if (idSqlField == null) {
            entity.setUpdateLockVersionSql(null);
        } else {
            String condition = String.valueOf(this.getDialect().escape(idSqlField.getColumn())) + " = " + this.getPlaceholder(idSqlField);
            for (SqlField sqlField : lockVersionList) {
                condition = String.valueOf(condition) + " and " + this.getDialect().escape(sqlField.getColumn()) + " = " + this.getPlaceholder(sqlField);
            }
            String sql = String.format("update %s set %s where %s ", this.getDialect().escape(entity.getTable()), StrUtils.join(lockVersionColumnPropertyList, " , "), condition);
            entity.setUpdateLockVersionSql(sql);
        }
    }

    public void initializeDeleteSql(SqlEntity entity) {
        SqlField idSqlField = entity.getIdSqlField();
        if (idSqlField == null) {
            entity.setDeleteSql(null);
        } else {
            String condition = String.valueOf(this.getDialect().escape(idSqlField.getColumn())) + " = " + this.getPlaceholder(idSqlField);
            String sql = String.format(DELETE, this.getDialect().escape(entity.getTable()), condition);
            entity.setDeleteSql(sql);
        }
    }

    public void initializeSelectSql(SqlEntity entity) {
        SqlField idSqlField = entity.getIdSqlField();
        if (idSqlField == null) {
            entity.setSelectSql(null);
        } else {
            String condition = String.valueOf(this.getDialect().escape(idSqlField.getColumn())) + " = " + this.getPlaceholder(idSqlField);
            String sql = String.format(SELECT, this.getSelectColumns(entity), this.getDialect().escape(entity.getTable()), condition);
            entity.setSelectSql(sql);
        }
    }

    private String getSelectColumns(SqlEntity entity) {
        LinkedList<String> selectColumns = new LinkedList<String>();
        if (entity.isHasColumnAlias()) {
            Map<String, SqlField> sqlFieldMap = entity.getSqlFieldMap();
            for (String field : sqlFieldMap.keySet()) {
                SqlField sqlField = sqlFieldMap.get(field);
                if (sqlField.isTransient()) continue;
                selectColumns.add(String.valueOf(sqlField.getColumn()) + " as " + FieldNameUtils.snakeCase(sqlField.getField()));
            }
        } else {
            selectColumns.add("*");
        }
        return StrUtils.join(selectColumns, " , ");
    }
}

