/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.JoinField;
import com.simple.mybatis.sql.SqlEntity;
import com.simple.mybatis.sql.Statement;
import com.simple.mybatis.util.StrUtils;
import java.util.Map;

public class FromJoinStatement
extends Statement {
    public FromJoinStatement(Class<?> entityClass) {
        super(entityClass);
    }

    public String getFromJoin() {
        if (StrUtils.isBlank(this.joinClause)) {
            return this.getFromClause();
        }
        if (this.joinEntityClass == null) {
            throw new NullPointerException("Join Entity was not found");
        }
        Map<Class<?>, SqlEntity> entityMap = this.getParser().getSqlEntityMap();
        SqlEntity joinEntity = entityMap.get(this.joinEntityClass);
        if (joinEntity == null) {
            throw new NullPointerException("Join Entity is not scanned");
        }
        JoinField joinField = null;
        Map<Class<?>, JoinField> joinClazzMap = joinEntity.getJoinFieldMap();
        if (joinClazzMap != null && joinClazzMap.containsKey(this.entityClass)) {
            joinField = joinClazzMap.get(this.entityClass);
        } else {
            Map<Class<?>, JoinField> clazzMap = entityMap.get(this.entityClass).getJoinFieldMap();
            if (clazzMap == null || !clazzMap.containsKey(this.joinEntityClass)) {
                throw new IllegalArgumentException("there is no Join association between " + this.entityClass + " and " + this.joinEntityClass);
            }
            joinField = clazzMap.get(this.joinEntityClass);
        }
        String property = null;
        String joinProperty = null;
        if (this.entityClass == joinField.getClazz()) {
            property = joinField.getField();
            joinProperty = joinField.getJoinField();
        } else {
            property = joinField.getJoinField();
            joinProperty = joinField.getField();
        }
        String table = this.getDialect().escape(entityMap.get(this.entityClass).getTable());
        String joinTable = this.getDialect().escape(entityMap.get(this.joinEntityClass).getTable());
        String column = this.getColumn("a.", this.entityClass, property);
        String joinColumn = this.getColumn("b.", this.joinEntityClass, joinProperty);
        StringBuilder builder = new StringBuilder();
        builder.append(table).append(" ").append("a").append(" ").append(this.joinClause).append(" ").append(joinTable).append(" ").append("b").append(" on ").append(column).append(" = ").append(joinColumn).append(" ");
        return builder.toString();
    }
}

