/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.Statement;
import com.simple.mybatis.util.StrUtils;

public class Insert
extends Statement {
    public static final String BATCH_SIGN = "%PLACE_HOLDER%";
    private boolean isBatch = false;
    private String listKey;
    private int listSize;

    public Insert(Class<?> entityClass) {
        super(entityClass);
    }

    public String toStatementString() {
        if (!this.isBatch) {
            return this.getSqlEntity().getInsertSql();
        }
        if (StrUtils.isBlank(this.listKey) && this.listSize == 0) {
            throw new IllegalArgumentException("Illegal collection parameters");
        }
        String sql = this.getSqlEntity().getInsertBatchSql();
        int index = sql.indexOf(" values ");
        String intoPart = sql.substring(0, index);
        String valuesPart = sql.substring(index + 8);
        StringBuilder builder = new StringBuilder();
        builder.append(intoPart).append(" values ");
        int i = 0;
        while (i < this.listSize) {
            builder.append(valuesPart.replaceAll(BATCH_SIGN, String.valueOf(this.listKey) + "[" + i + "]")).append(",");
            ++i;
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public String getListKey() {
        return this.listKey;
    }

    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }
}

