/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import java.util.HashMap;
import java.util.Map;

public enum JdbcType {
    INT("int", "INTEGER"),
    LONG("long", "BIGINT"),
    FLOAT("float", "FLOAT"),
    DOUBLE("double", "DOUBLE"),
    CHAR("char", "CHAR"),
    BOOLEAN("boolean", "BOOLEAN"),
    SHORT("short", "SMALLINT"),
    BYTE("byte", "SMALLINT"),
    BLOB("[B", "BLOB"),
    REF_INTEGER("java.lang.Integer", "INTEGER"),
    REF_LONG("java.lang.Long", "BIGINT"),
    REF_FLOAT("java.lang.Float", "INTEGER"),
    REF_DOUBLE("java.lang.Double", "DOUBLE"),
    REF_STRING("java.lang.String", "VARCHAR"),
    REF_DATE("java.util.Date", "TIMESTAMP"),
    REF_BOOLEAN("java.lang.Boolean", "BOOLEAN"),
    REF_SHORT("java.lang.Short", "SMALLINT"),
    REF_BYTE("java.lang.Byte", "SMALLINT"),
    REF_BIGDECIMAL("java.math.BigDecimal", "NUMERIC");

    public static Map<String, String> JDBC_MAP;
    public String prop;
    public String jdbc;

    static {
        JDBC_MAP = null;
    }

    public static String getJdbcType(String prop) {
        if (JDBC_MAP == null) {
            JDBC_MAP = new HashMap<String, String>();
            JdbcType[] jdbcTypeArray = JdbcType.values();
            int n = jdbcTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JdbcType o = jdbcTypeArray[n2];
                JDBC_MAP.put(o.prop, o.jdbc);
                ++n2;
            }
        }
        return JDBC_MAP.get(prop);
    }

    private JdbcType() {
    }

    private JdbcType(String prop, String jdbc) {
        this.prop = prop;
        this.jdbc = jdbc;
    }
}

