/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.SelectStatement;
import com.simple.mybatis.util.StrUtils;

public class Select
extends SelectStatement {
    private String selectClause;
    private String fetchClause;
    private String orderByClause;
    private String groupByClause;
    private boolean isId = false;

    public Select(Class<?> entityClass) {
        super(entityClass);
    }

    public String toStatementString() {
        int n;
        int n2;
        String[] stringArray;
        if (this.isId) {
            return this.getSqlEntity().getSelectSql();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" select ");
        if (StrUtils.isBlank(this.joinClause)) {
            builder.append(StrUtils.isBlank(this.selectClause) ? "*" : this.getSelectValue(this.selectClause, false));
        } else {
            if (StrUtils.isBlank(this.selectClause)) {
                builder.append("a.*");
            } else {
                builder.append(this.getSelectValue(this.selectClause, false));
            }
            if (StrUtils.isNotBlank(this.fetchClause)) {
                builder.append(",").append(this.getSelectValue(this.fetchClause, true));
            }
        }
        builder.append(" from ").append(this.getFromJoin());
        String queryClause = this.getQueryClause();
        if (StrUtils.isNotBlank(queryClause)) {
            builder.append(" where ").append(queryClause);
        }
        if (StrUtils.isNotBlank(this.groupByClause)) {
            String[] groups;
            stringArray = groups = this.groupByClause.trim().replaceAll(",", " ").split("\\s+");
            n2 = groups.length;
            n = 0;
            while (n < n2) {
                String group = stringArray[n];
                this.groupByClause = this.groupByClause.replaceAll(group, this.getColumn(group));
                ++n;
            }
            builder.append(" group by ").append(this.groupByClause);
        }
        if (StrUtils.isNotBlank(this.orderByClause)) {
            if (StrUtils.isNotBlank(this.orderByClause)) {
                String[] orders;
                stringArray = orders = this.orderByClause.trim().replaceAll(",", " ").split("\\s+");
                n2 = orders.length;
                n = 0;
                while (n < n2) {
                    String order = stringArray[n];
                    if (!"desc".equals(order.toLowerCase()) && !"asc".equals(order.toLowerCase())) {
                        this.orderByClause = this.orderByClause.replaceAll(order, this.getColumn(order));
                    }
                    ++n;
                }
            }
            builder.append(" order by ").append(this.orderByClause);
        }
        return builder.toString();
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public String getFetchClause() {
        return this.fetchClause;
    }

    public void setFetchClause(String fetchClause) {
        this.fetchClause = fetchClause;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setId(boolean isId) {
        this.isId = isId;
    }
}

