/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.annotation.Column;
import com.simple.mybatis.annotation.Id;
import com.simple.mybatis.annotation.Join;
import com.simple.mybatis.annotation.LockVersion;
import com.simple.mybatis.annotation.Table;
import com.simple.mybatis.annotation.Transient;
import com.simple.mybatis.config.SqlConfig;
import com.simple.mybatis.sql.AbstractSqlProcessor;
import com.simple.mybatis.sql.JoinField;
import com.simple.mybatis.sql.SqlEntity;
import com.simple.mybatis.sql.SqlField;
import com.simple.mybatis.util.FieldNameUtils;
import com.simple.mybatis.util.ReflectionUtil;
import com.simple.mybatis.util.StrUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParser {
    private static Logger log = LoggerFactory.getLogger(SqlParser.class);
    private AbstractSqlProcessor sqlProcessor;
    private static Map<Class<?>, SqlEntity> sqlEntityMap = new HashMap();
    private static SqlParser instance = new SqlParser();
    private SqlConfig sqlConfig;

    private SqlParser() {
        if (this.sqlConfig == null) {
            this.sqlConfig = new SqlConfig();
        }
    }

    public static SqlParser getInstance() {
        return instance;
    }

    public static String paserTable(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            return table.name();
        }
        return "";
    }

    public SqlEntity parse(Class<?> clazz) {
        if (!sqlEntityMap.containsKey(clazz)) {
            sqlEntityMap.put(clazz, this.paserEntity(clazz));
        }
        SqlEntity sqlEntity = sqlEntityMap.get(clazz);
        this.sqlProcessor.parseSql(sqlEntity);
        return sqlEntityMap.get(clazz);
    }

    private SqlEntity paserEntity(Class<?> clazz) {
        SqlEntity sqlEntity = new SqlEntity();
        sqlEntity.setClazz(clazz);
        sqlEntity.setTable(SqlParser.paserTable(clazz));
        boolean hasColumnAlias = false;
        boolean hasLockVersion = false;
        LinkedHashMap<String, SqlField> sqlFieldMap = new LinkedHashMap<String, SqlField>();
        LinkedHashMap joinFieldMap = new LinkedHashMap();
        Map<String, Field> fieldMap = ReflectionUtil.getDeclaredFields(clazz);
        List<String> parentFieldList = ReflectionUtil.getParentFields(clazz);
        for (String name : fieldMap.keySet()) {
            String column;
            Field field = fieldMap.get(name);
            SqlField sqlField = new SqlField();
            sqlField.setField(name);
            sqlField.setJdbcType(field.getType());
            if (field.isAnnotationPresent(Id.class)) {
                sqlField.setId(true);
                sqlEntity.setIdSqlField(sqlField);
            }
            if (field.isAnnotationPresent(Column.class)) {
                Column colAnno = field.getAnnotation(Column.class);
                String value = colAnno.value();
                boolean isPrivate = colAnno.isPrivate();
                if (parentFieldList.contains(name) && isPrivate) {
                    sqlField.setTransient(true);
                }
                if (StrUtils.isEmpty(value)) {
                    column = this.sqlConfig.isColumnSnakeCase() ? FieldNameUtils.snakeCase(name) : name;
                } else {
                    column = value;
                    hasColumnAlias = true;
                }
            } else {
                String string = column = this.sqlConfig.isColumnSnakeCase() ? FieldNameUtils.snakeCase(name) : name;
            }
            if (field.isAnnotationPresent(Transient.class)) {
                sqlField.setTransient(true);
            }
            if (field.isAnnotationPresent(LockVersion.class)) {
                sqlField.setLockVersion(true);
                hasLockVersion = true;
            }
            if (field.isAnnotationPresent(Join.class)) {
                Join join = field.getAnnotation(Join.class);
                Class<?> joinClazz = join.value();
                String joinField = join.field();
                joinFieldMap.put(joinClazz, new JoinField(name, clazz, joinField, joinClazz));
            }
            sqlField.setColumn(column);
            sqlFieldMap.put(name, sqlField);
        }
        sqlEntity.setHasColumnAlias(hasColumnAlias);
        sqlEntity.setHasLockVersion(hasLockVersion);
        sqlEntity.setSqlFieldMap(sqlFieldMap);
        sqlEntity.setJoinFieldMap(joinFieldMap);
        return sqlEntity;
    }

    public void setSqlProcessor(AbstractSqlProcessor sqlProcessor) {
        this.sqlProcessor = sqlProcessor;
    }

    public AbstractSqlProcessor getSqlProcessor() {
        return this.sqlProcessor;
    }

    public Map<Class<?>, SqlEntity> getSqlEntityMap() {
        return sqlEntityMap;
    }

    public SqlConfig getSqlConfig() {
        return this.sqlConfig;
    }

    public void setSqlConfig(SqlConfig sqlConfig) {
        this.sqlConfig = sqlConfig;
    }
}

