/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.AbstractSqlProcessor;
import com.simple.mybatis.sql.SqlDialect;
import com.simple.mybatis.sql.SqlEntity;
import com.simple.mybatis.sql.SqlField;
import com.simple.mybatis.sql.SqlParser;
import com.simple.mybatis.sql.WhereClause;
import com.simple.mybatis.util.StrUtils;
import java.util.LinkedList;
import java.util.List;

public class Statement {
    public static final String SIGN = "___";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String BLANK = " ";
    public static final String AS = " as ";
    public static final String ALIAS = "a";
    public static final String JOIN_ALIAS = "b";
    public static final String JOIN_SIGN = "_";
    protected String joinClause;
    protected Class<?> entityClass;
    protected Class<?> joinEntityClass;
    public List<WhereClause> whereClauses = new LinkedList<WhereClause>();

    public Statement(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public SqlParser getParser() {
        return SqlParser.getInstance();
    }

    public AbstractSqlProcessor getProcessor() {
        return this.getParser().getSqlProcessor();
    }

    public SqlDialect getDialect() {
        return this.getParser().getSqlProcessor().getDialect();
    }

    public String getTable() {
        return this.getSqlEntity().getTable();
    }

    public SqlEntity getSqlEntity(Class<?> clazz) {
        SqlEntity sqlEntity = this.getParser().getSqlEntityMap().get(clazz);
        if (sqlEntity == null) {
            throw new NullPointerException("Entity has not been scanned or Mapper corresponding Entity has not been found");
        }
        return sqlEntity;
    }

    public SqlEntity getSqlEntity() {
        return this.getSqlEntity(this.entityClass);
    }

    public String getColumn(String alias, Class<?> clazz, String property) {
        SqlField sqlField = this.getSqlEntity(clazz).getSqlFieldMap().get(property);
        if (sqlField == null) {
            return property;
        }
        return String.valueOf(alias) + this.getDialect().escape(sqlField.getColumn());
    }

    public String getColumn(String property) {
        Class<?> clazz = this.entityClass;
        String alias = "";
        if (StrUtils.isNotBlank(this.joinClause)) {
            if (StrUtils.isNotBlank(property) && property.startsWith(".")) {
                property = property.substring(1);
                clazz = this.joinEntityClass;
                alias = "b.";
            } else {
                alias = "a.";
            }
        }
        return this.getColumn(alias, clazz, property);
    }

    public String getFromClause() {
        return this.getDialect().escape(this.getTable());
    }

    public String getQueryClause() {
        if (this.whereClauses != null && this.whereClauses.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.whereClauses.size()) {
                List<WhereClause> subQueryClauseList;
                WhereClause queryClause = this.whereClauses.get(i);
                if ("and".equals(queryClause.getOperate().toLowerCase())) {
                    String sql = this.parseQueryClause(queryClause);
                    buffer.append(sql);
                } else if ("or".equals(queryClause.getOperate().toLowerCase()) && (subQueryClauseList = queryClause.getSubWhereClauses()).size() > 0) {
                    buffer.append(" and (");
                    int j = 0;
                    while (j < subQueryClauseList.size()) {
                        WhereClause subQueryClause = subQueryClauseList.get(j);
                        subQueryClause.setOperate(j == 0 ? "" : "or");
                        String sql = this.parseQueryClause(subQueryClause);
                        buffer.append(sql);
                        ++j;
                    }
                    buffer.append(")");
                }
                ++i;
            }
            return buffer.substring(4, buffer.length());
        }
        return null;
    }

    public String parseQueryClause(WhereClause whereClause) {
        StringBuilder builder = new StringBuilder();
        String operate = whereClause.getOperate();
        String property = whereClause.getProperty() == null ? "" : whereClause.getProperty().trim();
        String placeholder = whereClause.getPlaceholder() == null ? "" : whereClause.getPlaceholder().trim();
        String compare = whereClause.getCompare();
        Object value = whereClause.getValue();
        String alias = "";
        SqlEntity sqlEntity = this.getSqlEntity();
        if (StrUtils.isNotBlank(this.joinClause)) {
            if (property.startsWith(".")) {
                property = JOIN_SIGN + property.substring(1);
                alias = "b.";
                sqlEntity = this.getParser().getSqlEntityMap().get(this.joinEntityClass);
            } else {
                alias = "a.";
            }
        }
        String primitiveProperty = property.startsWith(JOIN_SIGN) ? property.substring(1, property.length()) : property;
        SqlField sqlField = sqlEntity.getSqlFieldMap().get(primitiveProperty);
        if (sqlField == null) {
            throw new NullPointerException("the " + primitiveProperty + " attribute of " + sqlEntity.getClazz().toString() + " is not found");
        }
        String column = this.getDialect().escape(sqlField.getColumn());
        placeholder = this.getProcessor().getPlaceholder(sqlField.getJdbcType(), Statement.sign(placeholder));
        builder.append(BLANK).append(operate).append(BLANK).append(alias).append(column);
        if ("like".equals(compare.toLowerCase())) {
            String likePlaceholder = "";
            String val = String.valueOf(value);
            likePlaceholder = val.startsWith("%") && val.endsWith("%") ? "'%'," + placeholder + ",'%'" : (val.startsWith("%") ? "'%'," + placeholder : (val.endsWith("%") ? String.valueOf(placeholder) + ",'%'" : placeholder));
            builder.append(" like ").append(this.getDialect().like(likePlaceholder));
        } else if ("between".equals(compare.toLowerCase())) {
            String minPlaceholder = this.getProcessor().getPlaceholder(sqlField.getJdbcType(), Statement.sign(whereClause.getMinPlaceholder()));
            String maxPlaceholder = this.getProcessor().getPlaceholder(sqlField.getJdbcType(), Statement.sign(whereClause.getMaxPlaceholder()));
            builder.append(" between ").append(minPlaceholder).append(" and ").append(maxPlaceholder);
        } else if ("is".equals(compare.toLowerCase()) || "in".equals(compare.toLowerCase()) || "not in".equals(compare.toLowerCase())) {
            builder.append(BLANK).append(compare).append(BLANK).append(value);
        } else {
            builder.append(BLANK).append(compare).append(BLANK).append(placeholder);
        }
        return builder.toString();
    }

    public List<WhereClause> getWhereClauses() {
        return this.whereClauses;
    }

    public void setWhereClauses(List<WhereClause> whereClauses) {
        this.whereClauses = whereClauses;
    }

    public void setJoinClause(String joinClause) {
        this.joinClause = joinClause;
    }

    public void setJoinEntityClass(Class<?> joinEntityClass) {
        this.joinEntityClass = joinEntityClass;
    }

    public static String sign(String property) {
        property = property.startsWith(".") ? JOIN_SIGN + property.substring(1) : property;
        return SIGN + property;
    }
}

