/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.sql;

import com.simple.mybatis.sql.SqlField;
import com.simple.mybatis.sql.Statement;
import com.simple.mybatis.util.ReflectionUtil;
import com.simple.mybatis.util.StrUtils;
import java.util.LinkedList;
import java.util.Map;

public class Update
extends Statement {
    private boolean isUpdateSelective = false;
    private boolean isLockVersion = false;
    private Object param;

    public Update(Class<?> entityClass) {
        super(entityClass);
    }

    public String toStatementString() {
        if (!this.isUpdateSelective) {
            if (this.isLockVersion) {
                return this.getSqlEntity().getUpdateLockVersionSql();
            }
            return this.getSqlEntity().getUpdateSql();
        }
        boolean isUpdateById = true;
        if (this.whereClauses != null && this.whereClauses.size() > 0) {
            isUpdateById = false;
        }
        Map<String, Object> paramMap = this.param instanceof Map ? (Map<String, Object>)this.param : ReflectionUtil.toMap(this.param);
        Map<String, SqlField> sqlFieldMap = this.getSqlEntity().getSqlFieldMap();
        LinkedList<SqlField> lockVersionList = new LinkedList<SqlField>();
        StringBuilder builder = new StringBuilder();
        builder.append("update ").append(this.getFromClause()).append(" set ");
        if (sqlFieldMap != null && sqlFieldMap.size() > 0) {
            for (String field : sqlFieldMap.keySet()) {
                Object value;
                SqlField sqlField = sqlFieldMap.get(field);
                String fieldName = sqlField.getField();
                if (isUpdateById && sqlField.isId() || sqlField.isTransient() || (value = paramMap.get(fieldName)) == null) continue;
                String column = this.getDialect().escape(sqlField.getColumn());
                if (this.isLockVersion && sqlField.isLockVersion()) {
                    lockVersionList.add(sqlField);
                    builder.append(column).append(" = 1 + ").append(column);
                } else {
                    builder.append(column).append(" = ").append(this.getProcessor().getPlaceholder(sqlField));
                }
                builder.append(" ,");
            }
        }
        builder.deleteCharAt(builder.length() - 1).toString();
        if (this.param instanceof Map) {
            String queryClause = this.getQueryClause();
            if (StrUtils.isNotBlank(queryClause)) {
                builder.append(" where ").append(queryClause);
            }
        } else {
            builder.append(" where ").append(this.getDialect().escape(this.getSqlEntity().getIdSqlField().getColumn())).append(" = ").append(this.getProcessor().getPlaceholder(this.getSqlEntity().getIdSqlField()));
        }
        if (this.isLockVersion) {
            for (SqlField sqlField : lockVersionList) {
                builder.append(" and ").append(this.getDialect().escape(sqlField.getColumn())).append(" = ").append(this.getProcessor().getPlaceholder(sqlField));
            }
        }
        return builder.toString();
    }

    public boolean isUpdateSelective() {
        return this.isUpdateSelective;
    }

    public void setUpdateSelective(boolean isUpdateSelective) {
        this.isUpdateSelective = isUpdateSelective;
    }

    public boolean isLockVersion() {
        return this.isLockVersion;
    }

    public void setLockVersion(boolean isLockVersion) {
        this.isLockVersion = isLockVersion;
    }

    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }
}

