/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.util;

import com.simple.mybatis.util.ClassHandler;
import com.simple.mybatis.util.PathClassResolver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner {
    private static Logger logger = LoggerFactory.getLogger(ClassScanner.class);
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private static Set<String> classSet = new HashSet<String>();
    private FileFilter fileFilter;
    private ClassHandler fileHandler;

    public ClassScanner(ClassHandler fileHandler, FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.fileHandler = fileHandler;
    }

    public void scanClass(boolean isSubpackage, List<String> packageList) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (String pkg : packageList) {
            String dir = PathClassResolver.convertClassToPath(pkg);
            this.scanPackage(loader, isSubpackage, dir);
        }
    }

    private void scanPackage(ClassLoader loader, boolean isRecursive, String dir) {
        try {
            Enumeration<URL> urls = loader.getResources(dir);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if (FILE_PROTOCOL.equals(protocol)) {
                    this.scanFilePackage(loader, isRecursive, dir, url);
                    continue;
                }
                if (!JAR_PROTOCOL.equals(protocol)) continue;
                this.scanJarPackage(loader, dir, url);
            }
        }
        catch (IOException e) {
            logger.error("Scan package error\uff1a" + dir, (Throwable)e);
        }
    }

    private void scanFilePackage(ClassLoader loader, boolean isRecursive, String dir, URL url) {
        String path = url.getPath();
        if (path == null) {
            return;
        }
        try {
            path = URLDecoder.decode(path, "utf-8");
            File dirFiles = new File(path);
            File[] files = dirFiles.listFiles(this.fileFilter);
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                String d = PathClassResolver.convertClassToPath(dir);
                if (file.isDirectory() && isRecursive) {
                    this.scanPackage(loader, isRecursive, String.valueOf(d) + "/" + fileName);
                } else {
                    String clazz = PathClassResolver.convertPathToClass(String.valueOf(d) + "/" + fileName);
                    if (!classSet.contains(clazz)) {
                        logger.debug("Scan Mybatis-JPA persistence class\uff1a{}", (Object)clazz);
                        classSet.add(clazz);
                        this.fileHandler.handle(loader.loadClass(clazz));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void scanJarPackage(ClassLoader loader, String dir, URL url) throws IOException {
        String jarFile = url.getPath();
        if (jarFile == null) {
            return;
        }
        try {
            jarFile = URLDecoder.decode(jarFile, "utf-8");
            int pos = jarFile.indexOf(33);
            jarFile = pos == -1 ? jarFile.substring(5) : jarFile.substring(5, pos);
            JarInputStream jis = new JarInputStream(new FileInputStream(jarFile));
            JarEntry entry = null;
            while ((entry = jis.getNextJarEntry()) != null) {
                String clazz;
                String fileName = entry.getName();
                if (!fileName.startsWith(dir) || !fileName.endsWith(".class") || classSet.contains(clazz = PathClassResolver.convertPathToClass(fileName))) continue;
                logger.debug("Scan Mybatis-JPA persistence class\uff1a{}", (Object)clazz);
                classSet.add(clazz);
                this.fileHandler.handle(loader.loadClass(clazz));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

