/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.util;

import com.simple.mybatis.exception.ObjectTypeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ObjectTypeUtil {
    private static final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FORMAT_HOUR = new SimpleDateFormat("yyyy-MM-dd HH");
    private static final SimpleDateFormat FORMAT_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat FORMAT_SECOND = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final String getString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Integer getInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        throw new ObjectTypeException("Can not cast to int, value : " + value);
    }

    public static final Float getFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new ObjectTypeException("Can not cast to float, value : " + value);
    }

    public static final Double getDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new ObjectTypeException("Can not cast to double, value : " + value);
    }

    public static final Long getLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Long.parseLong(strVal);
        }
        throw new ObjectTypeException("Can not cast to long, value : " + value);
    }

    public static final Boolean getBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                return null;
            }
            if ("true".equals(str) || "1".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str) || "0".equals(str)) {
                return Boolean.FALSE;
            }
        }
        throw new ObjectTypeException("Can not cast to int, value : " + value);
    }

    public static final Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            try {
                if (strVal.length() == 10) {
                    return FORMAT_DATE.parse(strVal);
                }
                if (strVal.length() == 13) {
                    return FORMAT_HOUR.parse(strVal);
                }
                if (strVal.length() == 16) {
                    return FORMAT_MINUTE.parse(strVal);
                }
                if (strVal.length() == 19) {
                    return FORMAT_SECOND.parse(strVal);
                }
            }
            catch (ParseException e) {
                if (strVal.length() == 0) {
                    return null;
                }
                longValue = Long.parseLong(strVal);
            }
        }
        if (longValue <= 0L) {
            throw new ObjectTypeException("Can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static final Short getShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new ObjectTypeException("Can not cast to short, value : " + value);
    }

    public static void main(String[] args) {
    }
}

