/*
 * Decompiled with CFR 0.152.
 */
package com.simple.mybatis.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtil {
    private static final Map<Class<?>, Map<String, Field>> FIELDS_CACHE = new ConcurrentHashMap(256);
    private static final Map<Class<?>, List<String>> PARENT_FIELDS_CACHE = new ConcurrentHashMap(256);

    public static Map<String, Field> getDeclaredFields(Class<?> clazz) {
        block10: {
            if (clazz == null) {
                throw new NullPointerException("Class must not be null");
            }
            if (FIELDS_CACHE.containsKey(clazz)) break block10;
            FIELDS_CACHE.put(clazz, new LinkedHashMap());
            Class<?> targetClass = clazz;
            do {
                Field[] fields;
                Field[] fieldArray = fields = targetClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        Field field = fieldArray[n2];
                        String name = field.getName();
                        try {
                            PropertyDescriptor pd = new PropertyDescriptor(name, targetClass);
                            if (pd.getReadMethod() == null) break block9;
                            if (pd.getWriteMethod() == null) {
                            }
                        }
                        catch (IntrospectionException e) {}
                        break block9;
                        Map<String, Field> fieldMap = FIELDS_CACHE.get(clazz);
                        if (!fieldMap.containsKey(name)) {
                            fieldMap.put(name, field);
                        }
                        if (!clazz.getName().equals(targetClass.getName())) {
                            if (!PARENT_FIELDS_CACHE.containsKey(clazz)) {
                                PARENT_FIELDS_CACHE.put(clazz, new LinkedList());
                            }
                            PARENT_FIELDS_CACHE.get(clazz).add(name);
                        }
                    }
                    ++n2;
                }
            } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        }
        return FIELDS_CACHE.get(clazz);
    }

    public static List<String> getParentFields(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return PARENT_FIELDS_CACHE.get(clazz);
    }

    public static Object getValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static void setValue(Field field, Object target, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Map<String, Object> toMap(Object target) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Field> fieldMap = ReflectionUtil.getDeclaredFields(target.getClass());
        for (String name : fieldMap.keySet()) {
            Field field = fieldMap.get(name);
            Object object = ReflectionUtil.getValue(field, target);
            map.put(name, object);
        }
        return map;
    }
}

