/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TokenCreateParams;
import com.stripe.param.TokenRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class Token
extends ApiResource
implements HasId {
    @SerializedName(value="bank_account")
    BankAccount bankAccount;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="client_ip")
    String clientIp;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="used")
    Boolean used;

    public static Token create(Map<String, Object> params) throws StripeException {
        return Token.create(params, (RequestOptions)null);
    }

    public static Token create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tokens");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Token.class, options);
    }

    public static Token create(TokenCreateParams params) throws StripeException {
        return Token.create(params, (RequestOptions)null);
    }

    public static Token create(TokenCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tokens");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Token.class, options);
    }

    public static Token retrieve(String token) throws StripeException {
        return Token.retrieve(token, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Token retrieve(String token, RequestOptions options) throws StripeException {
        return Token.retrieve(token, (Map<String, Object>)null, options);
    }

    public static Token retrieve(String token, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tokens/%s", ApiResource.urlEncodeId(token)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Token.class, options);
    }

    public static Token retrieve(String token, TokenRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tokens/%s", ApiResource.urlEncodeId(token)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Token.class, options);
    }

    @Generated
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public String getClientIp() {
        return this.clientIp;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getUsed() {
        return this.used;
    }

    @Generated
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUsed(Boolean used) {
        this.used = used;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$used = this.getUsed();
        Boolean other$used = other.getUsed();
        if (this$used == null ? other$used != null : !((Object)this$used).equals(other$used)) {
            return false;
        }
        BankAccount this$bankAccount = this.getBankAccount();
        BankAccount other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $used = this.getUsed();
        result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
        BankAccount $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

