/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Payout;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.CreditReversal;
import com.stripe.model.treasury.OutboundPayment;
import com.stripe.model.treasury.ReceivedCreditCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.ReceivedCreditCreateParams;
import com.stripe.param.treasury.ReceivedCreditListParams;
import com.stripe.param.treasury.ReceivedCreditRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class ReceivedCredit
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="failure_code")
    String failureCode;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="hosted_regulatory_receipt_url")
    String hostedRegulatoryReceiptUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="initiating_payment_method_details")
    InitiatingPaymentMethodDetails initiatingPaymentMethodDetails;
    @SerializedName(value="linked_flows")
    LinkedFlows linkedFlows;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="network")
    String network;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reversal_details")
    ReversalDetails reversalDetails;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static ReceivedCreditCollection list(Map<String, Object> params) throws StripeException {
        return ReceivedCredit.list(params, (RequestOptions)null);
    }

    public static ReceivedCreditCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/received_credits");
        return ApiResource.requestCollection(url, params, ReceivedCreditCollection.class, options);
    }

    public static ReceivedCreditCollection list(ReceivedCreditListParams params) throws StripeException {
        return ReceivedCredit.list(params, (RequestOptions)null);
    }

    public static ReceivedCreditCollection list(ReceivedCreditListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/received_credits");
        return ApiResource.requestCollection(url, params, ReceivedCreditCollection.class, options);
    }

    public static ReceivedCredit retrieve(String id) throws StripeException {
        return ReceivedCredit.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ReceivedCredit retrieve(String id, RequestOptions options) throws StripeException {
        return ReceivedCredit.retrieve(id, (Map<String, Object>)null, options);
    }

    public static ReceivedCredit retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/received_credits/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ReceivedCredit.class, options);
    }

    public static ReceivedCredit retrieve(String id, ReceivedCreditRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/received_credits/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ReceivedCredit.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getHostedRegulatoryReceiptUrl() {
        return this.hostedRegulatoryReceiptUrl;
    }

    @Generated
    public InitiatingPaymentMethodDetails getInitiatingPaymentMethodDetails() {
        return this.initiatingPaymentMethodDetails;
    }

    @Generated
    public LinkedFlows getLinkedFlows() {
        return this.linkedFlows;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNetwork() {
        return this.network;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public ReversalDetails getReversalDetails() {
        return this.reversalDetails;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setHostedRegulatoryReceiptUrl(String hostedRegulatoryReceiptUrl) {
        this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInitiatingPaymentMethodDetails(InitiatingPaymentMethodDetails initiatingPaymentMethodDetails) {
        this.initiatingPaymentMethodDetails = initiatingPaymentMethodDetails;
    }

    @Generated
    public void setLinkedFlows(LinkedFlows linkedFlows) {
        this.linkedFlows = linkedFlows;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setNetwork(String network) {
        this.network = network;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReversalDetails(ReversalDetails reversalDetails) {
        this.reversalDetails = reversalDetails;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceivedCredit)) {
            return false;
        }
        ReceivedCredit other = (ReceivedCredit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        String other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
        if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InitiatingPaymentMethodDetails this$initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
        InitiatingPaymentMethodDetails other$initiatingPaymentMethodDetails = other.getInitiatingPaymentMethodDetails();
        if (this$initiatingPaymentMethodDetails == null ? other$initiatingPaymentMethodDetails != null : !((Object)this$initiatingPaymentMethodDetails).equals(other$initiatingPaymentMethodDetails)) {
            return false;
        }
        LinkedFlows this$linkedFlows = this.getLinkedFlows();
        LinkedFlows other$linkedFlows = other.getLinkedFlows();
        if (this$linkedFlows == null ? other$linkedFlows != null : !((Object)this$linkedFlows).equals(other$linkedFlows)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ReversalDetails this$reversalDetails = this.getReversalDetails();
        ReversalDetails other$reversalDetails = other.getReversalDetails();
        if (this$reversalDetails == null ? other$reversalDetails != null : !((Object)this$reversalDetails).equals(other$reversalDetails)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceivedCredit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        result = result * 59 + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InitiatingPaymentMethodDetails $initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
        result = result * 59 + ($initiatingPaymentMethodDetails == null ? 43 : ((Object)$initiatingPaymentMethodDetails).hashCode());
        LinkedFlows $linkedFlows = this.getLinkedFlows();
        result = result * 59 + ($linkedFlows == null ? 43 : ((Object)$linkedFlows).hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ReversalDetails $reversalDetails = this.getReversalDetails();
        result = result * 59 + ($reversalDetails == null ? 43 : ((Object)$reversalDetails).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class InitiatingPaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="balance")
        String balance;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="financial_account")
        FinancialAccount financialAccount;
        @SerializedName(value="issuing_card")
        String issuingCard;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public String getBalance() {
            return this.balance;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public FinancialAccount getFinancialAccount() {
            return this.financialAccount;
        }

        @Generated
        public String getIssuingCard() {
            return this.issuingCard;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setBalance(String balance) {
            this.balance = balance;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setFinancialAccount(FinancialAccount financialAccount) {
            this.financialAccount = financialAccount;
        }

        @Generated
        public void setIssuingCard(String issuingCard) {
            this.issuingCard = issuingCard;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitiatingPaymentMethodDetails)) {
                return false;
            }
            InitiatingPaymentMethodDetails other = (InitiatingPaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            FinancialAccount this$financialAccount = this.getFinancialAccount();
            FinancialAccount other$financialAccount = other.getFinancialAccount();
            if (this$financialAccount == null ? other$financialAccount != null : !((Object)this$financialAccount).equals(other$financialAccount)) {
                return false;
            }
            String this$issuingCard = this.getIssuingCard();
            String other$issuingCard = other.getIssuingCard();
            if (this$issuingCard == null ? other$issuingCard != null : !this$issuingCard.equals(other$issuingCard)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitiatingPaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            FinancialAccount $financialAccount = this.getFinancialAccount();
            result = result * 59 + ($financialAccount == null ? 43 : ((Object)$financialAccount).hashCode());
            String $issuingCard = this.getIssuingCard();
            result = result * 59 + ($issuingCard == null ? 43 : $issuingCard.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class FinancialAccount
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="network")
            String network;

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FinancialAccount)) {
                    return false;
                }
                FinancialAccount other = (FinancialAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                return !(this$network == null ? other$network != null : !this$network.equals(other$network));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FinancialAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }
    }

    public static class LinkedFlows
    extends StripeObject {
        @SerializedName(value="credit_reversal")
        String creditReversal;
        @SerializedName(value="issuing_authorization")
        String issuingAuthorization;
        @SerializedName(value="issuing_transaction")
        String issuingTransaction;
        @SerializedName(value="source_flow")
        String sourceFlow;
        @SerializedName(value="source_flow_details")
        SourceFlowDetails sourceFlowDetails;
        @SerializedName(value="source_flow_type")
        String sourceFlowType;

        @Generated
        public String getCreditReversal() {
            return this.creditReversal;
        }

        @Generated
        public String getIssuingAuthorization() {
            return this.issuingAuthorization;
        }

        @Generated
        public String getIssuingTransaction() {
            return this.issuingTransaction;
        }

        @Generated
        public String getSourceFlow() {
            return this.sourceFlow;
        }

        @Generated
        public SourceFlowDetails getSourceFlowDetails() {
            return this.sourceFlowDetails;
        }

        @Generated
        public String getSourceFlowType() {
            return this.sourceFlowType;
        }

        @Generated
        public void setCreditReversal(String creditReversal) {
            this.creditReversal = creditReversal;
        }

        @Generated
        public void setIssuingAuthorization(String issuingAuthorization) {
            this.issuingAuthorization = issuingAuthorization;
        }

        @Generated
        public void setIssuingTransaction(String issuingTransaction) {
            this.issuingTransaction = issuingTransaction;
        }

        @Generated
        public void setSourceFlow(String sourceFlow) {
            this.sourceFlow = sourceFlow;
        }

        @Generated
        public void setSourceFlowDetails(SourceFlowDetails sourceFlowDetails) {
            this.sourceFlowDetails = sourceFlowDetails;
        }

        @Generated
        public void setSourceFlowType(String sourceFlowType) {
            this.sourceFlowType = sourceFlowType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkedFlows)) {
                return false;
            }
            LinkedFlows other = (LinkedFlows)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$creditReversal = this.getCreditReversal();
            String other$creditReversal = other.getCreditReversal();
            if (this$creditReversal == null ? other$creditReversal != null : !this$creditReversal.equals(other$creditReversal)) {
                return false;
            }
            String this$issuingAuthorization = this.getIssuingAuthorization();
            String other$issuingAuthorization = other.getIssuingAuthorization();
            if (this$issuingAuthorization == null ? other$issuingAuthorization != null : !this$issuingAuthorization.equals(other$issuingAuthorization)) {
                return false;
            }
            String this$issuingTransaction = this.getIssuingTransaction();
            String other$issuingTransaction = other.getIssuingTransaction();
            if (this$issuingTransaction == null ? other$issuingTransaction != null : !this$issuingTransaction.equals(other$issuingTransaction)) {
                return false;
            }
            String this$sourceFlow = this.getSourceFlow();
            String other$sourceFlow = other.getSourceFlow();
            if (this$sourceFlow == null ? other$sourceFlow != null : !this$sourceFlow.equals(other$sourceFlow)) {
                return false;
            }
            SourceFlowDetails this$sourceFlowDetails = this.getSourceFlowDetails();
            SourceFlowDetails other$sourceFlowDetails = other.getSourceFlowDetails();
            if (this$sourceFlowDetails == null ? other$sourceFlowDetails != null : !((Object)this$sourceFlowDetails).equals(other$sourceFlowDetails)) {
                return false;
            }
            String this$sourceFlowType = this.getSourceFlowType();
            String other$sourceFlowType = other.getSourceFlowType();
            return !(this$sourceFlowType == null ? other$sourceFlowType != null : !this$sourceFlowType.equals(other$sourceFlowType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkedFlows;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $creditReversal = this.getCreditReversal();
            result = result * 59 + ($creditReversal == null ? 43 : $creditReversal.hashCode());
            String $issuingAuthorization = this.getIssuingAuthorization();
            result = result * 59 + ($issuingAuthorization == null ? 43 : $issuingAuthorization.hashCode());
            String $issuingTransaction = this.getIssuingTransaction();
            result = result * 59 + ($issuingTransaction == null ? 43 : $issuingTransaction.hashCode());
            String $sourceFlow = this.getSourceFlow();
            result = result * 59 + ($sourceFlow == null ? 43 : $sourceFlow.hashCode());
            SourceFlowDetails $sourceFlowDetails = this.getSourceFlowDetails();
            result = result * 59 + ($sourceFlowDetails == null ? 43 : ((Object)$sourceFlowDetails).hashCode());
            String $sourceFlowType = this.getSourceFlowType();
            result = result * 59 + ($sourceFlowType == null ? 43 : $sourceFlowType.hashCode());
            return result;
        }

        public static class SourceFlowDetails
        extends StripeObject {
            @SerializedName(value="credit_reversal")
            CreditReversal creditReversal;
            @SerializedName(value="outbound_payment")
            OutboundPayment outboundPayment;
            @SerializedName(value="payout")
            Payout payout;
            @SerializedName(value="type")
            String type;

            @Generated
            public CreditReversal getCreditReversal() {
                return this.creditReversal;
            }

            @Generated
            public OutboundPayment getOutboundPayment() {
                return this.outboundPayment;
            }

            @Generated
            public Payout getPayout() {
                return this.payout;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setCreditReversal(CreditReversal creditReversal) {
                this.creditReversal = creditReversal;
            }

            @Generated
            public void setOutboundPayment(OutboundPayment outboundPayment) {
                this.outboundPayment = outboundPayment;
            }

            @Generated
            public void setPayout(Payout payout) {
                this.payout = payout;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceFlowDetails)) {
                    return false;
                }
                SourceFlowDetails other = (SourceFlowDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                CreditReversal this$creditReversal = this.getCreditReversal();
                CreditReversal other$creditReversal = other.getCreditReversal();
                if (this$creditReversal == null ? other$creditReversal != null : !((Object)this$creditReversal).equals(other$creditReversal)) {
                    return false;
                }
                OutboundPayment this$outboundPayment = this.getOutboundPayment();
                OutboundPayment other$outboundPayment = other.getOutboundPayment();
                if (this$outboundPayment == null ? other$outboundPayment != null : !((Object)this$outboundPayment).equals(other$outboundPayment)) {
                    return false;
                }
                Payout this$payout = this.getPayout();
                Payout other$payout = other.getPayout();
                if (this$payout == null ? other$payout != null : !((Object)this$payout).equals(other$payout)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SourceFlowDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                CreditReversal $creditReversal = this.getCreditReversal();
                result = result * 59 + ($creditReversal == null ? 43 : ((Object)$creditReversal).hashCode());
                OutboundPayment $outboundPayment = this.getOutboundPayment();
                result = result * 59 + ($outboundPayment == null ? 43 : ((Object)$outboundPayment).hashCode());
                Payout $payout = this.getPayout();
                result = result * 59 + ($payout == null ? 43 : ((Object)$payout).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class ReversalDetails
    extends StripeObject {
        @SerializedName(value="deadline")
        Long deadline;
        @SerializedName(value="restricted_reason")
        String restrictedReason;

        @Generated
        public Long getDeadline() {
            return this.deadline;
        }

        @Generated
        public String getRestrictedReason() {
            return this.restrictedReason;
        }

        @Generated
        public void setDeadline(Long deadline) {
            this.deadline = deadline;
        }

        @Generated
        public void setRestrictedReason(String restrictedReason) {
            this.restrictedReason = restrictedReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReversalDetails)) {
                return false;
            }
            ReversalDetails other = (ReversalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$deadline = this.getDeadline();
            Long other$deadline = other.getDeadline();
            if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
                return false;
            }
            String this$restrictedReason = this.getRestrictedReason();
            String other$restrictedReason = other.getRestrictedReason();
            return !(this$restrictedReason == null ? other$restrictedReason != null : !this$restrictedReason.equals(other$restrictedReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReversalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $deadline = this.getDeadline();
            result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
            String $restrictedReason = this.getRestrictedReason();
            result = result * 59 + ($restrictedReason == null ? 43 : $restrictedReason.hashCode());
            return result;
        }
    }

    public static class TestHelpers {
        private TestHelpers() {
        }

        public static ReceivedCredit create(Map<String, Object> params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ReceivedCredit create(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/treasury/received_credits");
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ReceivedCredit.class, options);
        }

        public static ReceivedCredit create(ReceivedCreditCreateParams params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ReceivedCredit create(ReceivedCreditCreateParams params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/treasury/received_credits");
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ReceivedCredit.class, options);
        }
    }
}

