/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncTask;
import com.sun.grizzly.arp.DefaultAsyncExecutor;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskBase;
import java.io.IOException;
import java.util.logging.Level;

public class AsyncProcessorTask
extends TaskBase
implements AsyncTask {
    private AsyncExecutor asyncExecutor;
    private int stage = 0;

    public void doTask() throws IOException {
        boolean continueExecution = true;
        while (continueExecution) {
            try {
                switch (this.stage) {
                    case 0: {
                        continueExecution = this.asyncExecutor.preExecute();
                        if (!continueExecution) {
                            this.asyncExecutor.getAsyncHandler().returnTask(this);
                            return;
                        }
                        this.stage = 1;
                        break;
                    }
                    case 1: {
                        this.stage = 2;
                        continueExecution = this.asyncExecutor.interrupt();
                        break;
                    }
                    case 4: {
                        continueExecution = this.asyncExecutor.execute();
                        this.stage = 2;
                        break;
                    }
                    case 2: {
                        this.asyncExecutor.postExecute();
                        this.asyncExecutor.getAsyncHandler().returnTask(this);
                        return;
                    }
                }
            }
            catch (Throwable t) {
                SelectorThread.logger().log(Level.SEVERE, t.getMessage(), t);
                if (this.stage <= 1) {
                    this.stage = 2;
                    continue;
                }
                this.stage = 0;
                throw new RuntimeException(t);
            }
        }
    }

    public int getStage() {
        return this.stage;
    }

    public void recycle() {
        this.stage = 0;
        if (this.asyncExecutor instanceof DefaultAsyncExecutor) {
            ((DefaultAsyncExecutor)this.asyncExecutor).recycle();
        }
    }

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public void setStage(int stage) {
        this.stage = stage;
    }

    public void setProcessorTask(ProcessorTask task) {
    }

    public ProcessorTask getProcessorTask() {
        return this.asyncExecutor == null ? null : this.asyncExecutor.getProcessorTask();
    }
}

