/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.logger;

import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.log4j.Log4jLoggerFactory;
import com.taobao.middleware.logger.nop.NopLoggerFactory;
import com.taobao.middleware.logger.slf4j.Slf4jLoggerFactory;
import com.taobao.middleware.logger.support.ILoggerFactory;
import com.taobao.middleware.logger.support.LogLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static volatile ILoggerFactory LOGGER_FACTORY;
    private static Map<String, Logger> loggerCache;

    private LoggerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger = loggerCache.get(name);
        if (logger == null) {
            ILoggerFactory iLoggerFactory = LOGGER_FACTORY;
            synchronized (iLoggerFactory) {
                logger = loggerCache.get(name);
                if (logger == null) {
                    logger = LOGGER_FACTORY.getLogger(name);
                    loggerCache.put(name, logger);
                }
            }
        }
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    private static void setLoggerFactory(ILoggerFactory loggerFactory) {
        if (loggerFactory != null) {
            LOGGER_FACTORY = loggerFactory;
        }
    }

    static {
        try {
            LoggerFactory.setLoggerFactory(new Slf4jLoggerFactory());
            LogLog.info("Init JM logger with Slf4jLoggerFactory success, " + LoggerFactory.class.getClassLoader());
        }
        catch (Throwable e1) {
            try {
                LoggerFactory.setLoggerFactory(new Log4jLoggerFactory());
                LogLog.info("Init JM logger with Log4jLoggerFactory, " + LoggerFactory.class.getClassLoader());
            }
            catch (Throwable e2) {
                LoggerFactory.setLoggerFactory(new NopLoggerFactory());
                LogLog.warn("Init JM logger with NopLoggerFactory, pay attention. " + LoggerFactory.class.getClassLoader(), e2);
            }
        }
        loggerCache = new ConcurrentHashMap<String, Logger>();
    }
}

