/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.jmx.mbean;

import com.taobao.pandora.boot.loader.BaseLaunchURLClassLoader;
import com.taobao.pandora.boot.loader.jmx.mbean.ClassInfoMBean;
import com.taobao.pandora.boot.loader.util.JmxUtils;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ClassInfo
implements ClassInfoMBean {
    private BaseLaunchURLClassLoader baseLaunchURLClassLoader;
    private static ClassInfo classInfo;
    private static String objectName;

    private ClassInfo(BaseLaunchURLClassLoader baseLaunchURLClassLoader) {
        this.baseLaunchURLClassLoader = baseLaunchURLClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerMBean(BaseLaunchURLClassLoader baseLaunchURLClassLoader) {
        if (classInfo == null) {
            Class<ClassInfo> clazz = ClassInfo.class;
            // MONITORENTER : com.taobao.pandora.boot.loader.jmx.mbean.ClassInfo.class
            if (classInfo == null) {
                classInfo = new ClassInfo(baseLaunchURLClassLoader);
            }
            // MONITOREXIT : clazz
        }
        try {
            MBeanServer mBeanServer = JmxUtils.getMBeanServer();
            mBeanServer.registerMBean(classInfo, new ObjectName(objectName));
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void unregisterMBean() {
        try {
            MBeanServer mBeanServer = JmxUtils.getMBeanServer();
            mBeanServer.unregisterMBean(new ObjectName(objectName));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String[] getwebappUnloadedJars() {
        HashSet<String> allJars = new HashSet<String>(this.baseLaunchURLClassLoader.getWebappJars());
        allJars.removeAll(this.baseLaunchURLClassLoader.getUsedJars());
        return allJars.toArray(new String[allJars.size()]);
    }

    @Override
    public String[] getwebappLoadedJars() {
        return this.baseLaunchURLClassLoader.getUsedJars().toArray(new String[this.baseLaunchURLClassLoader.getUsedJars().size()]);
    }

    @Override
    public String[] getpandoraJars() {
        return this.baseLaunchURLClassLoader.getPandoraJars().toArray(new String[this.baseLaunchURLClassLoader.getPandoraJars().size()]);
    }

    @Override
    public Map<String, Object[]> listResources(String path) {
        return null;
    }

    @Override
    public String[] getClassLocations(String className) {
        return new String[0];
    }

    @Override
    public String[] getJarLocations(String jarFileNamePattern) {
        return new String[0];
    }

    @Override
    public URL[] getURLs() {
        return new URL[0];
    }

    @Override
    public byte[] getContent(String file) {
        return new byte[0];
    }

    static {
        String projectName = System.getProperty("project.name", "default");
        projectName = projectName.replaceAll("[-_]{1,}", ".");
        objectName = "com.taobao.pandora.boot.project." + projectName + ":type=WebappClassLoader";
    }
}

