/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.jmx.mbean;

import com.taobao.pandora.boot.loader.jmx.mbean.HealthMBean;
import com.taobao.pandora.boot.loader.util.JmxUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Health
implements HealthMBean {
    private String status = "starting";
    private static CountDownLatch LATCH = new CountDownLatch(1);
    private static AtomicBoolean INIT = new AtomicBoolean(false);
    private static Health INSTANCE = new Health();

    private Health() {
    }

    @Override
    public void startup() {
        this.status = "success";
    }

    @Override
    public void await() {
        try {
            LATCH.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String preload() {
        return this.status;
    }

    @Override
    public boolean shutdown() {
        LATCH.countDown();
        return true;
    }

    public static Health getInstance() {
        return INSTANCE;
    }

    public static void registMBean() {
        if (INIT.compareAndSet(false, true)) {
            try {
                MBeanServer mBeanServer = JmxUtils.getMBeanServer();
                mBeanServer.registerMBean(INSTANCE, Health.getHealthName());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void markStartup() {
        try {
            MBeanServer mBeanServer = JmxUtils.getMBeanServer();
            mBeanServer.invoke(Health.getHealthName(), "startup", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void markAwait() throws InterruptedException {
        try {
            MBeanServer mBeanServer = JmxUtils.getMBeanServer();
            mBeanServer.invoke(Health.getHealthName(), "await", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static ObjectName getHealthName() throws MalformedObjectNameException {
        ObjectName name = new ObjectName("com.taobao.pandora.boot.bootstrap:type=Health");
        return name;
    }
}

