/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.common.config;

import com.tcbj.common.config.Config;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.common.config.ConfigLoader;
import com.tcbj.common.config.GenericConfigObject;
import com.tcbj.common.config.exception.LoadConfigErrorException;
import com.tcbj.common.config.exception.ParamErrorException;
import com.tcbj.common.config.impl.LocalConfigLoader;
import com.tcbj.common.config.impl.RemoteConfigLoader;
import com.tcbj.util.ThreadPools;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProccesor {
    public static Logger logger = LoggerFactory.getLogger(ConfigProccesor.class);
    private ConfigLoader configLoader;
    private GenericConfigObject configObject;
    private ScheduledExecutorService schedual = ThreadPools.newScheduledExecutorService((int)1, (String)"global-config-load");

    public ConfigProccesor(GenericConfigObject configObject) {
        if ("local".equals(configObject.getConfigType())) {
            this.configLoader = new LocalConfigLoader();
        } else if ("remote".equals(configObject.getConfigType())) {
            this.configLoader = new RemoteConfigLoader();
        } else {
            throw new ParamErrorException("invalid config Type");
        }
        this.configObject = configObject;
    }

    public void startup() {
        ConfigTask task = new ConfigTask();
        task.run();
    }

    public void stop() {
        if (!this.schedual.isShutdown()) {
            this.schedual.shutdown();
        }
    }

    private class ConfigTask
    implements Runnable {
        private ConfigTask() {
        }

        public void run() {
            logger.info("==================load config starting================");
            try {
                Config config = ConfigProccesor.this.configLoader.loadConfig(ConfigProccesor.this.configObject);
                ConfigFactory.set(config);
            }
            catch (Exception e) {
                logger.error("load config failed:" + ConfigProccesor.this.configObject);
                throw new LoadConfigErrorException("\u65e0\u6cd5\u83b7\u53d6\u8fdc\u7a0b\u914d\u7f6e\u4fe1\u606f");
            }
            finally {
                ConfigProccesor.this.schedual.schedule(this, (long)ConfigProccesor.this.configObject.getInterval(), TimeUnit.MINUTES);
            }
        }
    }
}

