/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common;

import com.plat.csp.dao.common.TableMetaInfo;
import com.tcbj.util.Beans;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableMetaInfoFactory {
    private static String jdbc_url = "jdbc:postgresql://192.168.103.6:5432/cspbusdb?useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull";
    private static String jdbc_username = "cspbususer";
    private static String jdbc_password = "cspbuspassword";
    private static String driverClassName = "org.postgresql.Driver";
    private static Map<String, TableMetaInfo> metas;

    private static void initTableInfo() {
        List<Map<String, Object>> list = TableMetaInfoFactory.doConnect();
        HashMap<String, TableMetaInfo> map = new HashMap<String, TableMetaInfo>();
        if (Beans.isNotEmpty(list)) {
            list.forEach(m -> {
                TableMetaInfo tm;
                boolean isPk;
                String field = m.get("field").toString();
                String type = m.get("type").toString();
                String table = m.get("tab").toString();
                boolean bl = isPk = !Beans.isEmpty(m.get("pk"));
                if (!map.containsKey(table)) {
                    tm = new TableMetaInfo();
                    map.put(table, tm);
                } else {
                    tm = (TableMetaInfo)map.get(table);
                }
                tm.getFieldTypeMapping().put(field, type);
                if (isPk) {
                    tm.setPrimaryKey(field);
                }
            });
        }
        metas = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableMetaInfo getTableMetaInfo(String tabName) {
        if (!Beans.isEmpty(metas)) return metas.get(tabName);
        Class<TableMetaInfoFactory> clazz = TableMetaInfoFactory.class;
        synchronized (TableMetaInfoFactory.class) {
            if (!Beans.isEmpty(metas)) return metas.get(tabName);
            TableMetaInfoFactory.initTableInfo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metas.get(tabName);
        }
    }

    private static List<Map<String, Object>> doConnect() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String sql = "SELECT c.relname as tab, a.attname AS field, t.typname AS type, (select 1 from pg_constraint pc where pc.contype = 'p' and pc.conrelid = c.oid and a.attnum = ANY(pc.conkey)) as pk FROM  pg_class c,pg_attribute a, pg_type t WHERE c.relname like 't_%' and a.attnum > 0 and a.attrelid = c.oid  and a.atttypid = t.oid and c.relkind ='r' ORDER BY c.relname";
        try {
            Class.forName(driverClassName);
            Connection c = DriverManager.getConnection(jdbc_url, jdbc_username, jdbc_password);
            PreparedStatement ps = c.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("tab", rs.getObject("tab"));
                m.put("type", rs.getObject("type"));
                m.put("field", rs.getObject("field"));
                m.put("pk", rs.getObject("pk"));
                result.add(m);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

