/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common;

import com.plat.csp.dao.common.DialectHandler;
import com.plat.csp.dao.common.SqlContext;
import com.plat.csp.dao.common.TableMetaInfo;
import com.plat.csp.dao.util.CamelUtil;
import com.plat.csp.dao.util.Reflects;
import com.tcbj.util.BeanMap;
import com.tcbj.util.Beans;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlBuilder {
    public static SqlContext buildInsertSql(Object entity, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList params = new ArrayList();
        BeanMap map = new BeanMap(entity);
        map.keySet().stream().filter(f -> !primaryKey.equals(CamelUtil.toUnderline(f))).forEach(fName -> {
            String columnName = CamelUtil.toUnderline(fName);
            sql.append(columnName).append(",");
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            args.append(typeArg).append(",");
            params.add(map.get(fName));
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildBatchInsertSql(List<?> entity, DialectHandler handler, TableMetaInfo meta) {
        Class<?> clazz = entity.get(0).getClass();
        String tabName = meta.getTabName();
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList params = new ArrayList();
        List<PropertyDescriptor> fields = Reflects.getAllField(clazz);
        fields.forEach(f -> {
            if (!primaryKey.equals(CamelUtil.toUnderline(f.getName()))) {
                String columnName = CamelUtil.toUnderline(f.getName());
                sql.append(columnName).append(",");
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                args.append(typeArg).append(",");
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        entity.forEach(obj -> {
            ArrayList param = new ArrayList();
            fields.stream().filter(f -> !primaryKey.contains(CamelUtil.toUnderline(f.getName()))).forEach(f -> param.add(Reflects.getValue(obj, f.getName())));
            params.add(param.toArray());
        });
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildUpdateSql(Object entity, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String primaryField = meta.getPrimaryKey();
        sql.append("update ");
        sql.append(tabName);
        sql.append(" set ");
        BeanMap map = new BeanMap(entity);
        map.keySet().forEach(fName -> {
            if (!primaryField.equals(CamelUtil.toUnderline(fName))) {
                String columnName = CamelUtil.toUnderline(fName);
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                sql.append(columnName).append("=").append(typeArg).append(",");
                params.add(map.get(fName));
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ");
        String typeArg = handler.toInsertSqlFragment(primaryField, meta.getFieldTypeMapping().get(primaryField));
        sql.append(primaryField).append("=").append(typeArg);
        params.add(map.get((Object)CamelUtil.toProperty(primaryField)));
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildBatchUpdateSql(List<?> entity, DialectHandler handler, TableMetaInfo meta) {
        Class<?> clazz = entity.get(0).getClass();
        String tabName = meta.getTabName();
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("update ").append(tabName).append(" set ");
        ArrayList params = new ArrayList();
        List<PropertyDescriptor> fields = Reflects.getAllField(clazz);
        StringBuilder pk = new StringBuilder();
        fields.forEach(f -> {
            String columnName = CamelUtil.toUnderline(f.getName());
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            if (!primaryKey.equals(CamelUtil.toUnderline(f.getName()))) {
                sql.append(columnName).append("=").append(typeArg).append(",");
            } else {
                pk.append(" where ").append(primaryKey).append(" = ").append(typeArg);
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append((CharSequence)pk);
        entity.forEach(obj -> {
            ArrayList<Object> param = new ArrayList<Object>();
            fields.stream().filter(f -> !primaryKey.equals(CamelUtil.toUnderline(f.getName()))).forEach(f -> param.add(Reflects.getValue(obj, f.getName())));
            param.add(Reflects.getValue(obj, primaryKey));
            params.add(param.toArray());
        });
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildSelectSql(Class entity, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        StringBuilder sql = new StringBuilder("select ");
        List<PropertyDescriptor> fields = Reflects.getAllField(entity);
        fields.forEach(f -> {
            String columnName = CamelUtil.toUnderline(f.getName());
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            sql.append(typeArg).append(",");
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from ").append(tabName);
        return new SqlContext(sql.toString());
    }

    public static SqlContext buildInsertSqlForMap(Map<String, Object> map, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        Map<String, String> fields = meta.getFieldTypeMapping();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList params = new ArrayList();
        fields.forEach((k, v) -> {
            if (!k.equals(meta.getPrimaryKey())) {
                sql.append((String)k).append(",");
                String typeArg = handler.toInsertSqlFragment((String)k, (String)v);
                args.append(typeArg).append(",");
                params.add(map.get(CamelUtil.toProperty(k)));
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildUpdateSqlForMap(Map<String, Object> map, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String primaryField = meta.getPrimaryKey();
        sql.append("update ");
        sql.append(tabName);
        sql.append(" set ");
        map.keySet().forEach(fName -> {
            if (!primaryField.equals(CamelUtil.toUnderline(fName))) {
                String columnName = CamelUtil.toUnderline(fName);
                if (meta.getFieldTypeMapping().containsKey(columnName) && Beans.isNotEmpty(map.get(fName))) {
                    String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                    sql.append(columnName).append("=").append(typeArg).append(",");
                    params.add(map.get(fName));
                }
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ");
        String typeArg = handler.toInsertSqlFragment(primaryField, meta.getFieldTypeMapping().get(primaryField));
        sql.append(primaryField).append("=").append(typeArg);
        params.add(map.get(CamelUtil.toProperty(primaryField)));
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildBatchInsertSqlForMap(List<Map<String, Object>> data, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        Map<String, String> fields = meta.getFieldTypeMapping();
        ArrayList params = new ArrayList();
        StringBuilder sql = new StringBuilder();
        StringBuilder args = new StringBuilder(" (");
        sql.append("insert into ").append(tabName).append(" (");
        fields.forEach((k, v) -> {
            if (!k.equals(meta.getPrimaryKey())) {
                sql.append((String)k).append(",");
                String typeArg = handler.toInsertSqlFragment((String)k, (String)v);
                args.append(typeArg).append(",");
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        data.forEach(m -> {
            ArrayList param = new ArrayList();
            fields.keySet().stream().filter(k -> !k.equals(meta.getPrimaryKey())).forEach(f -> {
                Object o = m.get(CamelUtil.toProperty(f));
                if (Beans.isEmpty(o)) {
                    param.add(null);
                } else {
                    param.add(o);
                }
            });
            params.add(param.toArray());
        });
        return new SqlContext(sql.toString()).setParam(params);
    }

    public static SqlContext buildBatchUpdateSqlForMap(List<Map<String, Object>> data, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        String primaryKey = meta.getPrimaryKey();
        Map<String, String> fields = meta.getFieldTypeMapping();
        StringBuilder sql = new StringBuilder(" update " + tabName + " set ");
        ArrayList params = new ArrayList();
        SqlContext c = new SqlContext();
        data.forEach(m -> {
            ArrayList param = new ArrayList();
            fields.forEach((k, v) -> {
                if (!("creator".equals(k) || "create_time".equals(k) || primaryKey.equals(k))) {
                    if (Beans.isEmpty((Object)c.getSql())) {
                        sql.append((String)k).append("=").append(handler.toInsertSqlFragment((String)k, (String)v)).append(",");
                    }
                    param.add(m.get(CamelUtil.toProperty(k)));
                }
            });
            if (Beans.isEmpty((Object)c.getSql())) {
                sql.deleteCharAt(sql.length() - 1);
                sql.append(" where " + primaryKey + " =" + handler.toInsertSqlFragment(primaryKey, meta.getFieldTypeMapping().get(primaryKey)));
                c.setSql(sql.toString());
            }
            param.add(m.get(CamelUtil.toProperty(primaryKey)));
            params.add(param.toArray());
        });
        return c.setParam(params);
    }

    public static SqlContext buildDifBatchUpdateSqlForMap(List<Map<String, Object>> data, DialectHandler handler, TableMetaInfo meta) {
        String tabName = meta.getTabName();
        String primaryKey = meta.getPrimaryKey();
        Map<String, String> fields = meta.getFieldTypeMapping();
        HashMap sqlParamMap = new HashMap();
        String whereSql = " where " + primaryKey + " =" + handler.toInsertSqlFragment(primaryKey, meta.getFieldTypeMapping().get(primaryKey));
        SqlContext c = new SqlContext();
        data.forEach(m -> {
            ArrayList param = new ArrayList();
            StringBuilder sql = new StringBuilder(" update " + tabName + " set ");
            Set keySet = m.keySet();
            fields.forEach((k, v) -> {
                String kProp = CamelUtil.toProperty(k);
                if (!"creator".equals(k) && !"create_time".equals(k) && !primaryKey.equals(k) && keySet.contains(kProp)) {
                    sql.append((String)k).append("=").append(handler.toInsertSqlFragment((String)k, (String)v)).append(",");
                    param.add(m.get(kProp));
                }
            });
            sql.deleteCharAt(sql.length() - 1);
            sql.append(whereSql);
            String wholeSql = sql.toString();
            if (sqlParamMap.containsKey(wholeSql)) {
                List ps = (List)sqlParamMap.get(wholeSql);
                ps.add(param);
            } else {
                ArrayList ps = new ArrayList();
                ps.add(param);
                sqlParamMap.put(wholeSql, ps);
            }
            param.add(m.get(CamelUtil.toProperty(primaryKey)));
        });
        return c.setParam(sqlParamMap);
    }
}

