/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common;

import com.plat.csp.dao.common.DatabaseInfo;
import com.plat.csp.dao.common.DialectHandler;
import com.plat.csp.dao.common.TableMetaInfo;
import com.tcbj.util.Beans;
import com.tcbj.util.Log;
import com.tcbj.util.ThreadPools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class TableMetaInfoFactory {
    private static TableMetaInfoFactory instance = null;
    private Map<String, Map<String, TableMetaInfo>> tableMetaInfos = new HashMap<String, Map<String, TableMetaInfo>>();
    List<JdbcTemplate> templates = new ArrayList<JdbcTemplate>();
    private ScheduledExecutorService schedual = ThreadPools.newScheduledExecutorService((int)1, (String)"table-info-load");

    private TableMetaInfoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableMetaInfoFactory getInstance() {
        if (null != instance) return instance;
        Class<TableMetaInfoFactory> clazz = TableMetaInfoFactory.class;
        synchronized (TableMetaInfoFactory.class) {
            instance = new TableMetaInfoFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void addTemplate(JdbcTemplate template, DialectHandler dialect) {
        Connection conn = DataSourceUtils.getConnection((DataSource)template.getDataSource());
        try {
            if (!this.templates.contains(template)) {
                DatabaseMetaData meta = conn.getMetaData();
                String databaseName = meta.getDatabaseProductName();
                String databaseVersion = meta.getDatabaseProductVersion();
                DatabaseInfo dbInfo = new DatabaseInfo(template, dialect, databaseName, databaseVersion);
                this.templates.add(template);
                this.getTableInfo(dbInfo);
                TableTask task = new TableTask(dbInfo);
                this.schedual.schedule(task, 1L, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error getting database info ");
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)template.getDataSource());
        }
    }

    public void refreshTemplate(DatabaseInfo info) {
        try {
            this.getTableInfo(info);
        }
        catch (Exception e) {
            throw new RuntimeException("error getting database info ");
        }
    }

    private void getTableInfo(DatabaseInfo dbInfo) throws SQLException {
        JdbcTemplate template = dbInfo.getTemplate();
        String version = dbInfo.getDatabaseVersion();
        List result = template.queryForList(dbInfo.getHandler().getTableInfoSql(version));
        HashMap map = new HashMap();
        if (Beans.isNotEmpty((Object)result)) {
            result.forEach(m -> {
                TableMetaInfo tm;
                boolean isPk;
                String field = m.get("field").toString();
                String type = m.get("type").toString();
                String table = m.get("tab").toString();
                boolean bl = isPk = !Beans.isEmpty(m.get("pk"));
                if (!map.containsKey(table)) {
                    tm = new TableMetaInfo();
                    map.put(table, tm);
                } else {
                    tm = (TableMetaInfo)map.get(table);
                }
                tm.getFieldTypeMapping().put(field, type);
                if (isPk) {
                    tm.setPrimaryKey(field);
                }
            });
        }
        this.tableMetaInfos.put(template.toString(), map);
    }

    public TableMetaInfo getTableMetaInfo(String jdbcKey, String tabName) {
        Map<String, TableMetaInfo> map = this.tableMetaInfos.get(jdbcKey);
        if (Beans.isNotEmpty(map)) {
            return map.get(tabName);
        }
        return null;
    }

    class TableTask
    implements Runnable {
        DatabaseInfo info;

        public TableTask(DatabaseInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            Log.info((String)"loading table info");
            try {
                TableMetaInfoFactory.this.refreshTemplate(this.info);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

