/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common.impl;

import com.plat.csp.dao.common.BaseDao;
import com.plat.csp.dao.common.DialectHandler;
import com.plat.csp.dao.common.SqlBuilder;
import com.plat.csp.dao.common.SqlContext;
import com.plat.csp.dao.common.TableMetaInfo;
import com.plat.csp.dao.common.TableMetaInfoFactory;
import com.plat.csp.dao.common.impl.DefaultRowMapper;
import com.plat.csp.dao.common.impl.PostgresDialectHandler;
import com.plat.csp.dao.util.CamelUtil;
import com.plat.csp.dao.util.Page;
import com.plat.csp.dao.util.Reflects;
import com.plat.csp.dao.util.TableNameConverter;
import com.tcbj.util.Beans;
import com.tcbj.util.FreeMarkers;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;

public class BaseDaoImpl
implements BaseDao {
    private JdbcTemplate jdbcTemplate;
    private DialectHandler dialectHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DialectHandler getDialectHandler() {
        if (this.dialectHandler == null) {
            BaseDaoImpl baseDaoImpl = this;
            synchronized (baseDaoImpl) {
                this.dialectHandler = this.getCustomDialectHandler();
            }
        }
        return this.dialectHandler;
    }

    protected DialectHandler getCustomDialectHandler() {
        return new PostgresDialectHandler();
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        TableMetaInfoFactory.getInstance().addTemplate(jdbcTemplate, this.getDialectHandler());
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    private TableMetaInfo getTableMetaInfo(String tableName) {
        TableMetaInfo meta = TableMetaInfoFactory.getInstance().getTableMetaInfo(this.jdbcTemplate.toString(), tableName);
        return meta;
    }

    @Override
    public <T> long saveEntity(T entity) {
        String tableName = TableNameConverter.toTableName(entity.getClass().getSimpleName());
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext sqlContext = SqlBuilder.buildInsertSql(entity, this.getDialectHandler(), meta);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(con -> {
            PreparedStatement ps = con.prepareStatement(sqlContext.getSql().toString(), new String[]{meta.getPrimaryKey()});
            int index = 0;
            List params = (List)sqlContext.getParam();
            for (Object param : params) {
                this.preparedStatementSetObject(ps, ++index, param);
            }
            return ps;
        }, (KeyHolder)keyHolder);
        Reflects.setValue(entity, CamelUtil.toProperty(meta.getPrimaryKey()), keyHolder.getKey().longValue());
        return keyHolder.getKey().longValue();
    }

    @Override
    public <T> void updateEntity(T entity) {
        String tableName = TableNameConverter.toTableName(entity.getClass().getSimpleName());
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext sqlContext = SqlBuilder.buildUpdateSql(entity, this.getDialectHandler(), meta);
        List params = (List)sqlContext.getParam();
        this.jdbcTemplate.update(sqlContext.getSql(), params.toArray());
    }

    @Override
    public <T> void deleteEntity(T entity) {
        ArrayList<T> e = new ArrayList<T>();
        e.add(entity);
        this.batchUpdateEntity(e);
    }

    @Override
    public <T> void deleteEntityById(Serializable id, Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String primaryField = this.getTableMetaInfo(tableName).getPrimaryKey();
        String sql = "DELETE FROM " + tableName + " WHERE " + primaryField + " = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }

    @Override
    public <T> void deleteAllEntity(Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String sql = "truncate FROM " + tableName;
        this.jdbcTemplate.update(sql);
    }

    @Override
    public <T> void batchSaveEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        String tableName = TableNameConverter.toTableName(list.get(0).getClass().getSimpleName());
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext sqlContext = SqlBuilder.buildBatchInsertSql(list, this.getDialectHandler(), meta);
        List params = (List)sqlContext.getParam();
        this.jdbcTemplate.batchUpdate(sqlContext.getSql(), params);
    }

    @Override
    public <T> void batchUpdateEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        String tableName = TableNameConverter.toTableName(list.get(0).getClass().getSimpleName());
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext sqlContext = SqlBuilder.buildBatchUpdateSql(list, this.getDialectHandler(), meta);
        List params = (List)sqlContext.getParam();
        this.jdbcTemplate.batchUpdate(sqlContext.getSql(), params);
    }

    @Override
    public <T> void batchDeleteEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        String tableName = TableNameConverter.toTableName(list.get(0).getClass().getSimpleName());
        String primaryField = this.getTableMetaInfo(tableName).getPrimaryKey();
        StringBuilder sql = new StringBuilder(" delete from " + tableName + " where ");
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (T t : list) {
            Object[] id = new Object[]{Reflects.getValue(t, CamelUtil.toProperty(primaryField))};
            args.add(id);
        }
        this.jdbcTemplate.batchUpdate(sql.toString(), args);
    }

    @Override
    public <T> T findEntityById(Serializable id, Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String primaryName = this.getTableMetaInfo(tableName).getPrimaryKey();
        String sql = "SELECT * FROM " + tableName + " WHERE " + primaryName + " = ?";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new DefaultRowMapper(clazz), new Object[]{id});
        if (Beans.isEmpty((Object)list)) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <T> List<T> findAllEntity(Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        String sql = SqlBuilder.buildSelectSql(clazz, this.getDialectHandler(), meta).getSql();
        return this.jdbcTemplate.query(sql, (RowMapper)new DefaultRowMapper(clazz));
    }

    @Override
    public Page findByPage(String sql, List<Object> args, int pageNo, int pageSize, Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) from (").append(sql).append(") _tab");
        int totalRecord = Beans.isEmpty(args) ? ((Integer)this.jdbcTemplate.queryForObject(sb.toString(), Integer.class)).intValue() : ((Integer)this.jdbcTemplate.queryForObject(sb.toString(), args.toArray(), Integer.class)).intValue();
        List list = this.queryToList(sql, args, pageNo, pageSize, clazz);
        Page p = new Page(pageNo, pageSize, totalRecord, list);
        return p;
    }

    @Override
    public Page findByPage(String sql, List<Object> args, int pageNo, int pageSize) {
        return this.findByPage(sql, args, pageNo, pageSize, Map.class);
    }

    @Override
    public Page findByPage(String sql, int pageNo, int pageSize, Class<?> clazz) {
        return this.findByPage(sql, null, pageNo, pageSize, clazz);
    }

    @Override
    public Page findByPage(String sql, int pageNo, int pageSize) {
        return this.findByPage(sql, null, pageNo, pageSize, Map.class);
    }

    @Override
    public void executeSql(String sql) {
        this.jdbcTemplate.update(sql);
    }

    @Override
    public <T> List<T> queryToList(String sql) {
        return this.queryToList(sql, null, 0, 0, Map.class);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args) {
        return this.queryToList(sql, args, 0, 0, Map.class);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args, Class<T> clazz) {
        return this.queryToList(sql, args, 0, 0, clazz);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args, int pageNo, int pageSize, Class<?> clazz) {
        String actSql = pageNo == 0 || pageSize == 0 ? sql : this.getDialectHandler().getPageSql(sql, pageNo, pageSize);
        List list = null;
        list = Beans.isEmpty(args) ? this.jdbcTemplate.query(actSql, (RowMapper)new DefaultRowMapper(clazz)) : this.jdbcTemplate.query(actSql, args.toArray(), (RowMapper)new DefaultRowMapper(clazz));
        return list;
    }

    @Override
    public void executeSql(String sql, List<Object> args) {
        this.jdbcTemplate.update(sql, statement -> IntStream.range(0, args.size()).forEach(idx -> {
            try {
                this.preparedStatementSetObject(statement, idx + 1, args.get(idx));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public void batchExecuteSql(String sql, List<Object[]> args) {
        this.jdbcTemplate.batchUpdate(sql, args);
    }

    private void preparedStatementSetObject(PreparedStatement st, int index, Object value) throws SQLException {
        Object v = value;
        if (Beans.isNotEmpty((Object)value) && java.util.Date.class.isAssignableFrom(value.getClass())) {
            java.util.Date d = (java.util.Date)value;
            v = new Date(d.getTime());
        }
        st.setObject(index, v);
    }

    @Override
    public long saveMap(String tabName, Map<String, Object> map) {
        TableMetaInfo meta = this.getTableMetaInfo(TableNameConverter.toTableName(tabName));
        SqlContext sqlContext = SqlBuilder.buildInsertSqlForMap(map, this.getDialectHandler(), meta);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(con -> {
            PreparedStatement ps = con.prepareStatement(sqlContext.getSql().toString(), new String[]{meta.getPrimaryKey()});
            int index = 0;
            List params = (List)sqlContext.getParam();
            for (Object param : params) {
                this.preparedStatementSetObject(ps, ++index, param);
            }
            return ps;
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    @Override
    public void updateMap(String tabName, Map<String, Object> map) {
        TableMetaInfo meta = this.getTableMetaInfo(TableNameConverter.toTableName(tabName));
        SqlContext sqlContext = SqlBuilder.buildUpdateSqlForMap(map, this.getDialectHandler(), meta);
        List params = (List)sqlContext.getParam();
        this.jdbcTemplate.update(sqlContext.getSql(), params.toArray());
    }

    @Override
    public String getTemplateSql(String sqlKey, String isCommon, Map<String, Object> model) {
        HashMap<String, Object> mapTemplate = new HashMap<String, Object>();
        mapTemplate.put("sqlKey", sqlKey);
        if (Beans.isNotEmpty((Object)isCommon)) {
            mapTemplate.put("common", isCommon);
        }
        String result = "";
        String sqlVal = this.getSysSql(mapTemplate);
        List list = this.queryToList(sqlVal);
        Map map = (Map)list.get(0);
        if (map == null) {
            throw new RuntimeException("invalid request");
        }
        String sqlval = (String)map.get("sqlValue");
        result = FreeMarkers.renderString((String)sqlval, model);
        return result;
    }

    private String getSqlBuildToAnd(Map<String, Object> model) {
        String result = FreeMarkers.processTemplate((String)"/template/sqlBuildToAnd.ftl", model);
        return result;
    }

    private String getSysSql(Map<String, Object> model) {
        String result = FreeMarkers.processTemplate((String)"/template/template_sql.ftl", model);
        return result;
    }

    public String getTemplateSqlForAuto(String sqlKey, Map<String, Object> model) {
        HashMap<String, Object> mapTemplate = new HashMap<String, Object>();
        mapTemplate.put("sqlKey", sqlKey);
        String result = "";
        String sqlVal = this.getSysSql(mapTemplate);
        List list = this.queryToList(sqlVal);
        Map map = (Map)list.get(0);
        if (map == null) {
            return null;
        }
        result = (String)map.get("sqlValue");
        mapTemplate.clear();
        return result;
    }

    @Override
    public void batchInsertMap(String businessType, List<Map<String, Object>> data) {
        String tableName = TableNameConverter.toTableName(businessType);
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext c = SqlBuilder.buildBatchInsertSqlForMap(data, this.getDialectHandler(), meta);
        List params = (List)c.getParam();
        this.jdbcTemplate.batchUpdate(c.getSql(), params);
    }

    @Override
    public void batchUpdateMap(String businessType, List<Map<String, Object>> data) {
        this.newbatchUpdateMap(businessType, data);
    }

    private void newbatchUpdateMap(String businessType, List<Map<String, Object>> data) {
        String tableName = TableNameConverter.toTableName(businessType);
        TableMetaInfo meta = this.getTableMetaInfo(tableName);
        SqlContext c = SqlBuilder.buildDifBatchUpdateSqlForMap(data, this.getDialectHandler(), meta);
        Map param = (Map)c.getParam();
        Connection con = DataSourceUtils.getConnection((DataSource)this.jdbcTemplate.getDataSource());
        try {
            param.forEach((sql, params) -> {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement((String)sql);
                    for (List l : params) {
                        for (int i = 0; i < l.size(); ++i) {
                            Object o = l.get(i);
                            if (Beans.isNotEmpty(o) && java.util.Date.class.isAssignableFrom(o.getClass())) {
                                java.util.Date d = (java.util.Date)o;
                                o = new Date(d.getTime());
                            }
                            ps.setObject(i + 1, o);
                        }
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    JdbcUtils.closeStatement((Statement)ps);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.jdbcTemplate.getDataSource());
        }
    }
}

