/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common.impl;

import com.plat.csp.dao.util.CamelUtil;
import com.plat.csp.dao.util.Reflects;
import com.tcbj.util.BeanMap;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class DefaultRowMapper
implements RowMapper<Object> {
    private Class<?> clazz;

    public DefaultRowMapper(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
        if (Map.class.isAssignableFrom(this.clazz)) {
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(columnCount);
            for (int j = 1; j <= columnCount; ++j) {
                String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)j);
                String propName = CamelUtil.toProperty(column);
                Object value = resultSet.getObject(column);
                map.put(propName, value);
            }
            return map;
        }
        Object entity = Reflects.newInstance(this.clazz);
        BeanMap map = new BeanMap(entity);
        map.keySet().forEach(fName -> {
            String column = CamelUtil.toUnderline(fName);
            try {
                map.put(fName, resultSet.getObject(column));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return entity;
    }
}

