/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common.impl;

import com.plat.csp.dao.common.DialectHandler;

public class PostgresDialectHandler
implements DialectHandler {
    @Override
    public String getPageSql(String sql, int pageNo, int pageSize) {
        StringBuilder sb = new StringBuilder(sql);
        int startIndex = this.getStartIndex(pageNo, pageSize);
        sb.append(" limit ").append(pageSize).append(" offset ").append(startIndex);
        return sb.toString();
    }

    @Override
    public String toSelectSqlFragment(String field, String type) {
        if (type.startsWith("json")) {
            return " cast(" + field + " as text) as " + field;
        }
        return field;
    }

    @Override
    public String toInsertSqlFragment(String field, String type) {
        if (type.startsWith("json")) {
            return " cast(? as jsonb) ";
        }
        if (type.startsWith("time") || type.startsWith("date")) {
            return " ?::timestamp ";
        }
        if (!type.startsWith("varchar")) {
            return " ?::" + type;
        }
        return " ? ";
    }

    @Override
    public String getTableInfoSql(String version) {
        String sql = "SELECT c.relname as tab, a.attname AS field, t.typname AS type, (select 1 from pg_constraint pc where pc.contype = 'p' and pc.conrelid = c.oid and a.attnum = ANY(pc.conkey)) as pk FROM  pg_class c,pg_attribute a, pg_type t WHERE c.relname like 't_%' and a.attnum > 0 and a.attrelid = c.oid  and a.atttypid = t.oid and c.relkind ='r' ORDER BY c.relname";
        return sql;
    }
}

