/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common;

import com.plat.csp.dao.common.DialectHandler;
import com.plat.csp.dao.common.SqlContext;
import com.plat.csp.dao.common.TableMetaInfo;
import com.plat.csp.dao.common.TableMetaInfoFactory;
import com.plat.csp.dao.util.CamelUtil;
import com.plat.csp.dao.util.Reflects;
import com.plat.csp.dao.util.TableNameConverter;
import com.tcbj.util.BeanMap;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SqlBuilder {
    public static SqlContext buildInsertSql(Object entity, DialectHandler handler) {
        String tabName = TableNameConverter.toTableName(entity.getClass().getSimpleName());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList<Object> params = new ArrayList<Object>();
        BeanMap map = new BeanMap(entity);
        map.keySet().stream().filter(f -> !primaryKey.equals(CamelUtil.toUnderline(f))).forEach(fName -> {
            String columnName = CamelUtil.toUnderline(fName);
            sql.append(columnName).append(",");
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            args.append(typeArg).append(",");
            params.add(map.get(fName));
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        return new SqlContext(sql.toString()).setParams(params);
    }

    public static SqlContext buildBatchInsertSql(List<?> entity, DialectHandler handler) {
        Class<?> clazz = entity.get(0).getClass();
        String tabName = TableNameConverter.toTableName(clazz.getSimpleName());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<PropertyDescriptor> fields = Reflects.getAllField(clazz);
        fields.forEach(f -> {
            if (!primaryKey.equals(CamelUtil.toUnderline(f.getName()))) {
                String columnName = CamelUtil.toUnderline(f.getName());
                sql.append(columnName).append(",");
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                args.append(typeArg).append(",");
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        entity.forEach(obj -> {
            ArrayList param = new ArrayList();
            fields.stream().filter(f -> !primaryKey.contains(CamelUtil.toUnderline(f.getName()))).forEach(f -> param.add(Reflects.getValue(obj, f.getName())));
            params.add(param.toArray());
        });
        return new SqlContext(sql.toString()).setBatchParams(params);
    }

    public static SqlContext buildUpdateSql(Object entity, DialectHandler handler) {
        String tabName = TableNameConverter.toTableName(entity.getClass().getSimpleName());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String primaryField = meta.getPrimaryKey();
        sql.append("update ");
        sql.append(tabName);
        sql.append(" set ");
        BeanMap map = new BeanMap(entity);
        map.keySet().forEach(fName -> {
            if (!primaryField.equals(CamelUtil.toUnderline(fName))) {
                String columnName = CamelUtil.toUnderline(fName);
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                sql.append(columnName).append("=").append(typeArg).append(",");
                params.add(map.get(fName));
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ");
        String typeArg = handler.toInsertSqlFragment(primaryField, meta.getFieldTypeMapping().get(primaryField));
        sql.append(primaryField).append("=").append(typeArg);
        params.add(map.get((Object)CamelUtil.toProperty(primaryField)));
        return new SqlContext(sql.toString()).setParams(params);
    }

    public static SqlContext buildBatchUpdateSql(List<?> entity, DialectHandler handler) {
        Class<?> clazz = entity.get(0).getClass();
        String tabName = TableNameConverter.toTableName(clazz.getSimpleName());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("update ").append(tabName).append(" set ");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<PropertyDescriptor> fields = Reflects.getAllField(clazz);
        StringBuilder pk = new StringBuilder();
        fields.forEach(f -> {
            String columnName = CamelUtil.toUnderline(f.getName());
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            if (!primaryKey.equals(CamelUtil.toUnderline(f.getName()))) {
                sql.append(columnName).append("=").append(typeArg).append(",");
            } else {
                pk.append(" where ").append(primaryKey).append(" = ").append(typeArg);
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append((CharSequence)pk);
        entity.forEach(obj -> {
            ArrayList<Object> param = new ArrayList<Object>();
            fields.stream().filter(f -> !primaryKey.equals(CamelUtil.toUnderline(f.getName()))).forEach(f -> param.add(Reflects.getValue(obj, f.getName())));
            param.add(Reflects.getValue(obj, primaryKey));
            params.add(param.toArray());
        });
        return new SqlContext(sql.toString()).setBatchParams(params);
    }

    public static SqlContext buildSelectSql(Class entity, DialectHandler handler) {
        String tabName = TableNameConverter.toTableName(entity.getClass().getSimpleName());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        StringBuilder sql = new StringBuilder("select ");
        List<PropertyDescriptor> fields = Reflects.getAllField(entity);
        fields.forEach(f -> {
            String columnName = CamelUtil.toUnderline(f.getName());
            String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
            sql.append(typeArg).append(",");
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from ").append(tabName);
        return new SqlContext(sql.toString());
    }

    public static SqlContext buildInsertSqlForMap(String tabName, Map<String, Object> map, DialectHandler handler) {
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        String primaryKey = meta.getPrimaryKey();
        StringBuilder sql = new StringBuilder("insert into ").append(tabName).append(" (");
        StringBuilder args = new StringBuilder("(");
        ArrayList<Object> params = new ArrayList<Object>();
        map.keySet().stream().filter(f -> !primaryKey.equals(CamelUtil.toUnderline(f))).forEach(fName -> {
            String columnName = CamelUtil.toUnderline(fName);
            if (meta.getFieldTypeMapping().containsKey(columnName)) {
                sql.append(columnName).append(",");
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                args.append(typeArg).append(",");
                params.add(map.get(fName));
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")");
        args.append(")");
        sql.append(" values ").append((CharSequence)args);
        return new SqlContext(sql.toString()).setParams(params);
    }

    public static SqlContext buildUpdateSqlForMap(String tabName, Map<String, Object> map, DialectHandler handler) {
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String primaryField = meta.getPrimaryKey();
        sql.append("update ");
        sql.append(tabName);
        sql.append(" set ");
        map.keySet().forEach(fName -> {
            if (!primaryField.equals(CamelUtil.toUnderline(fName))) {
                String columnName = CamelUtil.toUnderline(fName);
                String typeArg = handler.toInsertSqlFragment(columnName, meta.getFieldTypeMapping().get(columnName));
                sql.append(columnName).append("=").append(typeArg).append(",");
                params.add(map.get(fName));
            }
        });
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ");
        String typeArg = handler.toInsertSqlFragment(primaryField, meta.getFieldTypeMapping().get(primaryField));
        sql.append(primaryField).append("=").append(typeArg);
        params.add(map.get(CamelUtil.toProperty(primaryField)));
        return new SqlContext(sql.toString()).setParams(params);
    }
}

