/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.dao.common.impl;

import com.plat.csp.dao.common.BaseDao;
import com.plat.csp.dao.common.DialectHandler;
import com.plat.csp.dao.common.SqlBuilder;
import com.plat.csp.dao.common.SqlContext;
import com.plat.csp.dao.common.TableMetaInfo;
import com.plat.csp.dao.common.TableMetaInfoFactory;
import com.plat.csp.dao.common.impl.DefaultRowMapper;
import com.plat.csp.dao.common.impl.PostgresDialectHandler;
import com.plat.csp.dao.util.CamelUtil;
import com.plat.csp.dao.util.Page;
import com.plat.csp.dao.util.Reflects;
import com.plat.csp.dao.util.TableNameConverter;
import com.tcbj.util.Beans;
import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class BaseDaoImpl
implements BaseDao {
    private JdbcTemplate jdbcTemplate;
    private DialectHandler dialectHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DialectHandler getDialectHandler() {
        if (this.dialectHandler == null) {
            BaseDaoImpl baseDaoImpl = this;
            synchronized (baseDaoImpl) {
                this.dialectHandler = this.getCustomDialectHandler();
            }
        }
        return this.dialectHandler;
    }

    protected DialectHandler getCustomDialectHandler() {
        return new PostgresDialectHandler();
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public <T> long saveEntity(T entity) {
        SqlContext sqlContext = SqlBuilder.buildInsertSql(entity, this.getDialectHandler());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(TableNameConverter.toTableName(entity.getClass().getSimpleName()));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(con -> {
            PreparedStatement ps = con.prepareStatement(sqlContext.getSql().toString(), new String[]{meta.getPrimaryKey()});
            int index = 0;
            for (Object param : sqlContext.getParams()) {
                this.preparedStatementSetObject(ps, ++index, param);
            }
            return ps;
        }, (KeyHolder)keyHolder);
        Reflects.setValue(entity, CamelUtil.toProperty(meta.getPrimaryKey()), keyHolder.getKey().longValue());
        return keyHolder.getKey().longValue();
    }

    @Override
    public <T> void updateEntity(T entity) {
        SqlContext sqlContext = SqlBuilder.buildUpdateSql(entity, this.getDialectHandler());
        this.jdbcTemplate.update(sqlContext.getSql(), sqlContext.getParams().toArray());
    }

    @Override
    public <T> void deleteEntity(T entity) {
        ArrayList<T> e = new ArrayList<T>();
        e.add(entity);
        this.batchUpdateEntity(e);
    }

    @Override
    public <T> void deleteEntityById(Serializable id, Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String primaryField = TableMetaInfoFactory.getTableMetaInfo(tableName).getPrimaryKey();
        String sql = "DELETE FROM " + tableName + " WHERE " + primaryField + " = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }

    @Override
    public <T> void deleteAllEntity(Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String sql = "truncate FROM " + tableName;
        this.jdbcTemplate.update(sql);
    }

    @Override
    public <T> void batchSaveEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        SqlContext sqlContext = SqlBuilder.buildBatchInsertSql(list, this.getDialectHandler());
        this.jdbcTemplate.batchUpdate(sqlContext.getSql(), sqlContext.getBatchParams());
    }

    @Override
    public <T> void batchUpdateEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        SqlContext sqlContext = SqlBuilder.buildBatchUpdateSql(list, this.getDialectHandler());
        this.jdbcTemplate.batchUpdate(sqlContext.getSql(), sqlContext.getBatchParams());
    }

    @Override
    public <T> void batchDeleteEntity(List<T> list) {
        if (Beans.isEmpty(list)) {
            return;
        }
        String tableName = TableNameConverter.toTableName(list.get(0).getClass().getSimpleName());
        String primaryField = TableMetaInfoFactory.getTableMetaInfo(tableName).getPrimaryKey();
        StringBuilder sql = new StringBuilder(" delete from " + tableName + " where ");
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (T t : list) {
            Object[] id = new Object[]{Reflects.getValue(t, CamelUtil.toProperty(primaryField))};
            args.add(id);
        }
        this.jdbcTemplate.batchUpdate(sql.toString(), args);
    }

    @Override
    public <T> T findEntityById(Serializable id, Class<T> clazz) {
        String tableName = TableNameConverter.toTableName(clazz.getSimpleName());
        String primaryName = TableMetaInfoFactory.getTableMetaInfo(tableName).getPrimaryKey();
        String sql = "SELECT * FROM " + tableName + " WHERE " + primaryName + " = ?";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new DefaultRowMapper(clazz), new Object[]{id});
        if (Beans.isEmpty((Object)list)) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <T> List<T> findAllEntity(Class<T> clazz) {
        String sql = SqlBuilder.buildSelectSql(clazz, this.getDialectHandler()).getSql();
        return this.jdbcTemplate.query(sql, (RowMapper)new DefaultRowMapper(clazz));
    }

    @Override
    public Page findByPage(String sql, List<Object> args, int pageNo, int pageSize, Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) from (").append(sql).append(") _tab");
        int totalRecord = (Integer)this.jdbcTemplate.queryForObject(sb.toString(), args.toArray(), Integer.class);
        List list = this.queryToList(sql, args, pageNo, pageSize, clazz);
        Page p = new Page(pageNo, pageSize, totalRecord, list);
        return p;
    }

    @Override
    public Page findByPage(String sql, List<Object> args, int pageNo, int pageSize) {
        return this.findByPage(sql, args, pageNo, pageSize, Map.class);
    }

    @Override
    public Page findByPage(String sql, int pageNo, int pageSize, Class<?> clazz) {
        return this.findByPage(sql, null, pageNo, pageSize, clazz);
    }

    @Override
    public Page findByPage(String sql, int pageNo, int pageSize) {
        return this.findByPage(sql, null, pageNo, pageSize, Map.class);
    }

    @Override
    public void executeSql(String sql) {
        this.jdbcTemplate.update(sql);
    }

    @Override
    public <T> List<T> queryToList(String sql) {
        return this.queryToList(sql, null, 0, 0, Map.class);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args) {
        return this.queryToList(sql, args, 0, 0, Map.class);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args, Class<T> clazz) {
        return this.queryToList(sql, args, 0, 0, clazz);
    }

    @Override
    public <T> List<T> queryToList(String sql, List<Object> args, int pageNo, int pageSize, Class<?> clazz) {
        String actSql = pageNo == 0 || pageSize == 0 ? sql : this.getDialectHandler().getPageSql(sql, pageNo, pageSize);
        List list = null;
        list = Beans.isEmpty(args) ? this.jdbcTemplate.query(actSql, (RowMapper)new DefaultRowMapper(clazz)) : this.jdbcTemplate.query(actSql, args.toArray(), (RowMapper)new DefaultRowMapper(clazz));
        return list;
    }

    @Override
    public void executeSql(String sql, List<Object> args) {
        this.jdbcTemplate.update(sql, statement -> IntStream.range(0, args.size()).forEach(idx -> {
            try {
                this.preparedStatementSetObject(statement, idx + 1, args.get(idx));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public void batchExecuteSql(String sql, List<Object[]> args) {
        this.jdbcTemplate.batchUpdate(sql, args);
    }

    private void preparedStatementSetObject(PreparedStatement st, int index, Object value) throws SQLException {
        Object v = value;
        if (Beans.isNotEmpty((Object)value) && java.util.Date.class.isAssignableFrom(value.getClass())) {
            java.util.Date d = (java.util.Date)value;
            v = new Date(d.getTime());
        }
        st.setObject(index, v);
    }

    @Override
    public long saveMap(String tabName, Map<String, Object> map) {
        SqlContext sqlContext = SqlBuilder.buildInsertSqlForMap(CamelUtil.toUnderline(tabName), map, this.getDialectHandler());
        TableMetaInfo meta = TableMetaInfoFactory.getTableMetaInfo(tabName);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(con -> {
            PreparedStatement ps = con.prepareStatement(sqlContext.getSql().toString(), new String[]{meta.getPrimaryKey()});
            int index = 0;
            for (Object param : sqlContext.getParams()) {
                this.preparedStatementSetObject(ps, ++index, param);
            }
            return ps;
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    @Override
    public void updateMap(String tabName, Map<String, Object> map) {
        SqlContext sqlContext = SqlBuilder.buildUpdateSqlForMap(CamelUtil.toUnderline(tabName), map, this.getDialectHandler());
        this.jdbcTemplate.update(sqlContext.getSql(), sqlContext.getParams().toArray());
    }
}

