/*
 * Decompiled with CFR 0.152.
 */
package com.plat.csp.iface.common;

import com.plat.csp.iface.common.ParamContext;
import com.tcbj.util.Jsons;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;

public class SimpleParamContext
implements ParamContext {
    private static final String JSON_PARAM = "jsonStr";
    private HttpServletResponse response;
    private Map<String, Object> params;
    private long startTime;
    private String method;

    public SimpleParamContext(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        this.response = response;
        this.startTime = System.currentTimeMillis();
        this.params = this.initParam(request);
        this.method = handler.getBeanType().getName() + ":" + handler.getMethod().getName();
    }

    private Map<String, Object> initParam(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Enumeration paramNames = request.getParameterNames();
        if (paramNames.hasMoreElements()) {
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                if (JSON_PARAM.equals(name)) {
                    Map p = (Map)Jsons.toBean((String)request.getParameter(name), Map.class);
                    param.putAll(p);
                    continue;
                }
                param.put(name, request.getParameter(name));
            }
        }
        return param;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public long getRunningTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public Map<String, Object> getParam() {
        return this.params;
    }

    @Override
    public String getMethod() {
        return this.method;
    }
}

