/*
 * Decompiled with CFR 0.152.
 */
package com.plat.framework.common;

import com.plat.framework.common.ParamContext;
import com.plat.framework.common.WrapParam;
import com.plat.framework.vo.UploadFileEntity;
import com.tcbj.util.Beans;
import com.tcbj.util.Jsons;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class SimpleParamContext
implements ParamContext {
    private static final String JSON_PARAM = "jsonStr";
    private static final String MULTIPART_MIME = "multipart/form-data";
    private HttpServletResponse response;
    private WrapParam params;
    private long startTime;
    private String method;

    public SimpleParamContext(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        this.response = response;
        this.startTime = System.currentTimeMillis();
        this.params = this.initParam(request);
        this.method = handler.getBeanType().getName() + ":" + handler.getMethod().getName();
    }

    private WrapParam initParam(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (Beans.isNotEmpty((Object)contentType) && contentType.toLowerCase().startsWith(MULTIPART_MIME)) {
            return this.initMultipartParam(request);
        }
        return this.commonInitParam(request);
    }

    private WrapParam initMultipartParam(HttpServletRequest request) {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        MultipartHttpServletRequest multipartRequest = resolver.resolveMultipart(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.putAll(this.commonInitParam((HttpServletRequest)multipartRequest).getParamMap());
        Map map = multipartRequest.getFileMap();
        if (Beans.isNotEmpty((Object)map)) {
            ArrayList<UploadFileEntity> files = new ArrayList<UploadFileEntity>();
            for (String key : map.keySet()) {
                MultipartFile file = (MultipartFile)map.get(key);
                UploadFileEntity fileEntity = new UploadFileEntity(file);
                if (file.getSize() <= 0L) continue;
                files.add(fileEntity);
            }
            param.put("_upload_File", files);
        }
        return new WrapParam(param);
    }

    private WrapParam commonInitParam(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Enumeration paramNames = request.getParameterNames();
        if (paramNames.hasMoreElements()) {
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                if (JSON_PARAM.equals(name)) {
                    Map p = (Map)Jsons.toBean((String)request.getParameter(name), Map.class);
                    param.putAll(p);
                    continue;
                }
                param.put(name, request.getParameter(name));
            }
        }
        return new WrapParam(param);
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public long getRunningTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public WrapParam getParam() {
        return this.params;
    }

    @Override
    public String getMethod() {
        return this.method;
    }
}

