/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.io;

import com.plat.redis.exception.ConfigNotFoundException;
import com.plat.redis.exception.ParseConfigFileException;
import com.plat.redis.io.RedisConfig;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.util.Beans;
import java.util.HashMap;
import java.util.Map;

public class ConfigLoader {
    public Map<String, RedisConfig> getConfig() {
        Map redizs = ConfigFactory.get().getAll();
        HashMap<String, RedisConfig> config = new HashMap<String, RedisConfig>();
        if (Beans.isEmpty((Object)redizs)) {
            throw new ConfigNotFoundException("redis config not found");
        }
        redizs.forEach((k, v) -> {
            if (!k.startsWith("redis")) {
                return;
            }
            String[] str = k.split(".");
            if (str.length == 1) {
                throw new ParseConfigFileException("error parsing config file");
            }
            String appId = str[1];
            if (config.containsKey(appId)) {
                return;
            }
            String nodes = (String)redizs.get(str[0] + appId + ".nodes");
            RedisConfig c = new RedisConfig(nodes);
            int max_idle = Beans.isEmpty(redizs.get(str[0] + appId + ".max_idle")) ? 5 : Integer.valueOf((String)redizs.get(str[0] + appId + ".max_idle"));
            int max_active = Beans.isEmpty(redizs.get(str[0] + appId + ".max_active")) ? 500 : Integer.valueOf((String)redizs.get(str[0] + appId + ".max_active"));
            long max_wait = Beans.isEmpty(redizs.get(str[0] + appId + ".max_wait")) ? 100000L : (long)Integer.valueOf((String)redizs.get(str[0] + appId + ".max_wait")).intValue();
            c.setMaxIdle(max_idle);
            c.setMaxTotal(max_active);
            c.setMaxWaitMillis(max_wait);
            config.put(appId, c);
        });
        return config;
    }
}

