/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.io;

import com.plat.redis.exception.ParseConfigFileException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;

public class RedisConfig
extends GenericObjectPoolConfig {
    private Set<HostAndPort> hosts;

    public RedisConfig(String hostStr) {
        this.hosts = new HashSet<HostAndPort>();
        try {
            String[] nodes;
            for (String s : nodes = hostStr.split(",")) {
                String[] node = s.split(":");
                String ip = node[0];
                int port = Integer.valueOf(node[1]);
                HostAndPort hap = new HostAndPort(ip, port);
                this.hosts.add(hap);
            }
        }
        catch (Exception e) {
            throw new ParseConfigFileException("parsing config file error");
        }
    }

    public RedisConfig(Set<HostAndPort> hosts) {
        this.hosts = hosts;
    }

    public Set<HostAndPort> getHosts() {
        return this.hosts;
    }
}

