/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.io;

import com.plat.redis.io.ConfigLoader;
import com.plat.redis.io.RedisConfig;
import com.plat.redis.service.RedisService;
import com.plat.redis.service.RedisServiceClusterImpl;
import com.tcbj.util.Beans;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisCluster;

public class RedisFactory {
    private static Map<String, RedisService> clusters = new HashMap<String, RedisService>();

    public static void initConfig() {
        ConfigLoader loader = new ConfigLoader();
        Map<String, RedisConfig> map = loader.getConfig();
        map.forEach((k, v) -> {
            if (clusters.containsKey(k)) {
                return;
            }
            JedisCluster cluster = new JedisCluster(v.getHosts(), (GenericObjectPoolConfig)v);
            RedisServiceClusterImpl r = new RedisServiceClusterImpl(cluster);
            clusters.put((String)k, r);
        });
    }

    public static RedisService getRedisFactory(String appId) {
        RedisService c = clusters.get(appId);
        if (Beans.isEmpty((Object)c)) {
            throw new RuntimeException("can not find appId cluster:" + appId);
        }
        return c;
    }

    static {
        RedisFactory.initConfig();
    }
}

