/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.io;

import com.plat.redis.io.ConfigLoader;
import com.plat.redis.io.RedisClusterConfig;
import com.plat.redis.io.RedisSentinelConfig;
import com.plat.redis.io.RedisSingleConfig;
import com.plat.redis.service.RedisService;
import com.plat.redis.service.RedisServiceClusterImpl;
import com.plat.redis.service.RedisServiceSingleImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisFactory {
    private static Map<String, RedisService> services = new HashMap<String, RedisService>();

    public static void initConfig() {
        ConfigLoader loader = new ConfigLoader();
        Map<String, GenericObjectPoolConfig> map = loader.getConfig();
        for (String k : map.keySet()) {
            JedisPool pool;
            GenericObjectPoolConfig rsc;
            RedisService r;
            GenericObjectPoolConfig v = map.get(k);
            if (services.containsKey(k)) continue;
            if (v instanceof RedisClusterConfig) {
                RedisClusterConfig rcc = (RedisClusterConfig)v;
                JedisCluster cluster = new JedisCluster(rcc.getHosts(), (GenericObjectPoolConfig)rcc);
                r = new RedisServiceClusterImpl(cluster);
                services.put(k, r);
                continue;
            }
            if (v instanceof RedisSingleConfig) {
                rsc = (RedisSingleConfig)v;
                pool = new JedisPool(rsc, rsc.getIp(), rsc.getPort());
                r = new RedisServiceSingleImpl((Pool<Jedis>)pool);
                services.put(k, r);
                continue;
            }
            if (!(v instanceof RedisSentinelConfig)) continue;
            rsc = (RedisSentinelConfig)v;
            pool = new JedisSentinelPool(rsc.getMasterName(), rsc.getSentinels(), rsc);
            r = new RedisServiceSingleImpl((Pool<Jedis>)pool);
            services.put(k, r);
        }
    }

    public static RedisService getRedisService(String appId) {
        RedisService c = services.get(appId);
        if (c == null) {
            throw new RuntimeException("can not find appId cluster:" + appId);
        }
        return c;
    }

    public static RedisService getRedisService() {
        if (services.keySet().size() > 1) {
            throw new RuntimeException("there is multiple datasource please choose one");
        }
        return services.get(services.keySet().iterator().next());
    }

    static {
        RedisFactory.initConfig();
    }
}

