/*
 * Decompiled with CFR 0.152.
 */
package com.plat.redis.util;

import com.plat.redis.exception.ParseConfigFileException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.HostAndPort;

public class RedisUtils {
    public static Map<String, String> toStringMap(Map<String, Object> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (map != null && map.size() > 0) {
            for (String k : map.keySet()) {
                Object v = map.get(k);
                if (v == null || "".equals(v)) continue;
                newMap.put(k, v.toString());
            }
        }
        return newMap;
    }

    public static Set<HostAndPort> toHostAndPort(String hostStr) {
        HashSet<HostAndPort> hosts = new HashSet<HostAndPort>();
        try {
            String[] nodes;
            for (String s : nodes = hostStr.split(",")) {
                String[] node = s.split(":");
                String ip = node[0];
                int port = Integer.valueOf(node[1]);
                HostAndPort hap = new HostAndPort(ip, port);
                hosts.add(hap);
            }
            return hosts;
        }
        catch (Exception e) {
            throw new ParseConfigFileException("parsing config file error");
        }
    }

    public static Set<String> toHostAndPortStr(String hostStr) {
        HashSet<String> hosts = new HashSet<String>();
        try {
            String[] nodes;
            for (String s : nodes = hostStr.split(",")) {
                hosts.add(s);
            }
            return hosts;
        }
        catch (Exception e) {
            throw new ParseConfigFileException("parsing config file error");
        }
    }
}

