/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.ability;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.ability.AbilityCondition;
import com.tcbj.crm.ability.AbilityService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.Ability;
import com.tcbj.crm.entity.AbilityRule;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ability"})
public class AbilityController
extends BaseController {
    @Autowired
    EmployeeService service;
    @Autowired
    AbilityService abilityService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AbilityCondition con, Model model) {
        Employee e = this.getCurrentEmployee();
        if ("1".equals(con.getState())) {
            con.setYear(DateUtils.getYear());
        }
        con.setPartnerId(e.getCurrentPartner().getId());
        Page pages = this.abilityService.getAbilityPage(con, pageno);
        model.addAttribute("abilitys", (Object)pages);
        model.addAttribute("con", (Object)con);
        return "ability/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(Model model) {
        Employee em = this.getCurrentEmployee();
        AbilityCondition con = new AbilityCondition();
        con.setPartnerId(em.getCurrentPartner().getId());
        model.addAttribute("abilitys", (Object)JSON.toJSONString(con.getAbilityList()));
        model.addAttribute("con", (Object)con);
        return "ability/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@Valid @RequestBody AbilityCondition con, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        List<Ability> abilitys = con.getAbilityList();
        for (Ability ability : abilitys) {
            ability.setPartnerId(e.getCurrentPartner().getId());
            ability.setYear(con.getYear());
            boolean isExist = this.abilityService.isExist(con);
            if (!isExist) continue;
            throw new AppException("5117");
        }
        this.abilityService.addAndupdate(con, e);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(AbilityCondition con, Integer returnYear, Model model) {
        Employee em = this.getCurrentEmployee();
        Calendar c = Calendar.getInstance();
        con.setPartnerId(em.getCurrentPartner().getId());
        if (StringUtils.isNull(returnYear)) {
            con.setYear(c.get(1));
        } else {
            con.setYear(returnYear);
        }
        List<Ability> abilitys = this.abilityService.getAbilityList(con);
        model.addAttribute("abilitys", (Object)JSON.toJSONString(abilitys));
        model.addAttribute("con", (Object)con);
        return "ability/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result update(@Valid @RequestBody AbilityCondition con, BindingResult errors, Model model, HttpServletRequest request) throws IOException {
        Employee em = this.getCurrentEmployee();
        this.abilityService.addAndupdate(con, em);
        return this.getSuccessResult(con.getYear());
    }

    @RequestMapping(value={"view.do"})
    public String get_view(String id, Model model) {
        Ability ability = this.abilityService.findById(id);
        model.addAttribute("ability", (Object)ability);
        return "ability/view.ftl";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, Model model) throws IOException {
        this.abilityService.delete(id);
        return this.redirect("/ability/list.do");
    }

    @RequestMapping(value={"rule.do"}, method={RequestMethod.GET})
    public String get_rule(String id, Model model) {
        List<AbilityRule> abilityRules = this.abilityService.getRules(id);
        model.addAttribute("rules", (Object)JSON.toJSONString(abilityRules));
        model.addAttribute("ability", (Object)this.abilityService.findById(id));
        model.addAttribute("id", (Object)id);
        return "ability/rule.ftl";
    }

    @RequestMapping(value={"rule.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_rule(@Valid @RequestBody Ability ability, BindingResult errors, Model model, HttpServletRequest request) {
        this.abilityService.save(ability);
        return this.getSuccessResult(ability.getId());
    }
}

